/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SampleStat {
    private final MinMax minmax = new MinMax();
    private long numSamples = 0L;
    private double a0 = 0.0;
    private double a1;
    private double s0 = 0.0;
    private double s1;

    public void reset() {
        this.numSamples = 0L;
        this.s0 = 0.0;
        this.a0 = 0.0;
        this.minmax.reset();
    }

    void reset(long numSamples, double a0, double a1, double s0, double s1, MinMax minmax) {
        this.numSamples = numSamples;
        this.a0 = a0;
        this.a1 = a1;
        this.s0 = s0;
        this.s1 = s1;
        this.minmax.reset(minmax);
    }

    public void copyTo(SampleStat other) {
        other.reset(this.numSamples, this.a0, this.a1, this.s0, this.s1, this.minmax);
    }

    public SampleStat add(double x) {
        this.minmax.add(x);
        return this.add(1L, x);
    }

    public SampleStat add(long nSamples, double x) {
        this.numSamples += nSamples;
        if (this.numSamples == 1L) {
            this.a0 = this.a1 = x;
            this.s0 = 0.0;
        } else {
            this.a1 = this.a0 + (x - this.a0) / (double)this.numSamples;
            this.s1 = this.s0 + (x - this.a0) * (x - this.a1);
            this.a0 = this.a1;
            this.s0 = this.s1;
        }
        return this;
    }

    public long numSamples() {
        return this.numSamples;
    }

    public double mean() {
        return this.numSamples > 0L ? this.a1 : 0.0;
    }

    public double variance() {
        return this.numSamples > 1L ? this.s1 / (double)(this.numSamples - 1L) : 0.0;
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public double min() {
        return this.minmax.min();
    }

    public double max() {
        return this.minmax.max();
    }

    public static class MinMax {
        static final double DEFAULT_MIN_VALUE = 3.4028234663852886E38;
        static final double DEFAULT_MAX_VALUE = (double)1.4E-45f;
        private double min = 3.4028234663852886E38;
        private double max = 1.4E-45f;

        public void add(double value) {
            if (value > this.max) {
                this.max = value;
            }
            if (value < this.min) {
                this.min = value;
            }
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public void reset() {
            this.min = 3.4028234663852886E38;
            this.max = 1.4E-45f;
        }

        public void reset(MinMax other) {
            this.min = other.min();
            this.max = other.max();
        }
    }
}

