/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence.replacement;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite3.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite3.internal.pagememory.persistence.PartitionDestructionLockManager;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite3.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointPages;
import org.apache.ignite3.internal.pagememory.persistence.replacement.DelayedPageReplacementTracker;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class DelayedDirtyPageWrite {
    private final WriteDirtyPage flushDirtyPage;
    private final int pageSize;
    private final ThreadLocal<ByteBuffer> byteBufThreadLoc;
    private final DelayedPageReplacementTracker tracker;
    private final PartitionDestructionLockManager partitionDestructionLockManager;
    @Nullable
    private DirtyFullPageId fullPageId;
    @Nullable
    private PersistentPageMemory pageMemory;
    @Nullable
    private CheckpointPages checkpointPages;

    DelayedDirtyPageWrite(WriteDirtyPage flushDirtyPage, ThreadLocal<ByteBuffer> byteBufThreadLoc, int pageSize, DelayedPageReplacementTracker tracker, PartitionDestructionLockManager partitionDestructionLockManager) {
        this.flushDirtyPage = flushDirtyPage;
        this.pageSize = pageSize;
        this.byteBufThreadLoc = byteBufThreadLoc;
        this.tracker = tracker;
        this.partitionDestructionLockManager = partitionDestructionLockManager;
    }

    public void copyPageToTemporaryBuffer(PersistentPageMemory pageMemory, DirtyFullPageId pageId, ByteBuffer originPageBuf, CheckpointPages checkpointPages) {
        this.tracker.lock(pageId.toFullPageId());
        ByteBuffer threadLocalBuf = this.byteBufThreadLoc.get();
        threadLocalBuf.rewind();
        long dstBufAddr = GridUnsafe.bufferAddress(threadLocalBuf);
        long srcBufAddr = GridUnsafe.bufferAddress(originPageBuf);
        GridUnsafe.copyMemory(srcBufAddr, dstBufAddr, this.pageSize);
        this.fullPageId = pageId;
        this.pageMemory = pageMemory;
        this.checkpointPages = checkpointPages;
    }

    public void flushCopiedPageIfExists() throws IgniteInternalCheckedException {
        if (this.fullPageId == null) {
            return;
        }
        assert (this.pageMemory != null) : this.fullPageId;
        assert (this.checkpointPages != null) : this.fullPageId;
        Throwable errorOnWrite = null;
        Lock partitionDestructionLock = this.partitionDestructionLockManager.destructionLock(GroupPartitionId.convert(this.fullPageId)).readLock();
        partitionDestructionLock.lock();
        try {
            this.flushDirtyPage.write(this.pageMemory, this.fullPageId, this.byteBufThreadLoc.get());
        }
        catch (Throwable t) {
            errorOnWrite = t;
            throw t;
        }
        finally {
            partitionDestructionLock.unlock();
            this.checkpointPages.unblockFsyncOnPageReplacement(this.fullPageId, errorOnWrite);
            this.tracker.unlock(this.fullPageId.toFullPageId());
            this.fullPageId = null;
            this.pageMemory = null;
            this.checkpointPages = null;
        }
    }
}

