/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import java.util.Collection;
import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite3.internal.network.message.ClassDescriptorMessageBuilder;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessage;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class ClassDescriptorMessageDeserializer
implements MessageDeserializer<ClassDescriptorMessage> {
    private final ClassDescriptorMessageBuilder msg;

    ClassDescriptorMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.classDescriptorMessage();
    }

    @Override
    public Class<ClassDescriptorMessage> klass() {
        return ClassDescriptorMessage.class;
    }

    @Override
    public ClassDescriptorMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte by = reader.readByte("attributes");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.attributes(by);
                reader.incrementState();
            }
            case 1: {
                String string = reader.readString("className");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.className(string);
                reader.incrementState();
            }
            case 2: {
                int n = reader.readInt("componentTypeDescriptorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.componentTypeDescriptorId(n);
                reader.incrementState();
            }
            case 3: {
                String string = reader.readString("componentTypeName");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.componentTypeName(string);
                reader.incrementState();
            }
            case 4: {
                int n = reader.readInt("descriptorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.descriptorId(n);
                reader.incrementState();
            }
            case 5: {
                Object c = reader.readCollection("fields", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fields((Collection<FieldDescriptorMessage>)c);
                reader.incrementState();
            }
            case 6: {
                byte by = reader.readByte("serializationFlags");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.serializationFlags(by);
                reader.incrementState();
            }
            case 7: {
                byte by = reader.readByte("serializationType");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.serializationType(by);
                reader.incrementState();
            }
            case 8: {
                int n = reader.readInt("superClassDescriptorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.superClassDescriptorId(n);
                reader.incrementState();
            }
            case 9: {
                String string = reader.readString("superClassName");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.superClassName(string);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClassDescriptorMessage.class);
    }
}

