/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.sql;

import java.time.ZoneId;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.sql.engine.SqlProperties;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.jetbrains.annotations.Nullable;

class ClientSqlProperties {
    @Nullable
    private final String schema;
    private final int pageSize;
    private final long queryTimeout;
    private final long idleTimeout;
    @Nullable
    private final String timeZoneId;

    ClientSqlProperties(ClientMessageUnpacker in) {
        this.schema = in.tryUnpackNil() ? null : IgniteNameUtils.parseIdentifier(in.unpackString());
        this.pageSize = in.tryUnpackNil() ? 1024 : in.unpackInt();
        this.queryTimeout = in.tryUnpackNil() ? 0L : in.unpackLong();
        this.idleTimeout = in.tryUnpackNil() ? 0L : in.unpackLong();
        this.timeZoneId = in.tryUnpackNil() ? null : in.unpackString();
        in.unpackInt();
        in.readBinaryUnsafe();
    }

    @Nullable
    public String schema() {
        return this.schema;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public long queryTimeout() {
        return this.queryTimeout;
    }

    public long idleTimeout() {
        return this.idleTimeout;
    }

    SqlProperties toSqlProps() {
        SqlProperties sqlProperties = new SqlProperties().queryTimeout(this.queryTimeout);
        if (this.schema != null) {
            sqlProperties.defaultSchema(this.schema);
        }
        if (this.timeZoneId != null) {
            sqlProperties.timeZoneId(ZoneId.of(this.timeZoneId));
        }
        return sqlProperties;
    }
}

