/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateRequest;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateRequestBuilder;

class LocalTablePartitionStateRequestDeserializer
implements MessageDeserializer<LocalTablePartitionStateRequest> {
    private final LocalTablePartitionStateRequestBuilder msg;

    LocalTablePartitionStateRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.localTablePartitionStateRequest();
    }

    public Class<LocalTablePartitionStateRequest> klass() {
        return LocalTablePartitionStateRequest.class;
    }

    public LocalTablePartitionStateRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("catalogVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.catalogVersion(tmp);
                reader.incrementState();
            }
            case 1: {
                Set tmp = reader.readSet("zonePartitionIds", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.zonePartitionIds(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalTablePartitionStateRequest.class);
    }
}

