/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.ForwardedRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.net.URIAuthority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestForwardedRequest {
    private final HttpRequest request = new BasicHttpRequest("GET", "/");
    private final HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
    private static final String FORWARDED_HEADER_NAME = "Forwarded";

    TestForwardedRequest() {
    }

    @Test
    void testProcess() throws IOException, HttpException {
        ForwardedRequest processor = new ForwardedRequest();
        InetSocketAddress remoteAddress = new InetSocketAddress("192.168.1.100", 12345);
        InetSocketAddress localAddress = new InetSocketAddress("127.0.0.1", 2263);
        EndpointDetails endpointDetails = (EndpointDetails)Mockito.mock(EndpointDetails.class);
        Mockito.when((Object)endpointDetails.getRemoteAddress()).thenReturn((Object)remoteAddress);
        Mockito.when((Object)endpointDetails.getLocalAddress()).thenReturn((Object)localAddress);
        String host = "somehost";
        int port = 8888;
        this.request.setAuthority(new URIAuthority("somehost", 8888));
        HttpVersion version = HttpVersion.HTTP_1_1;
        HttpCoreContext context = HttpCoreContext.create();
        context.setEndpointDetails(endpointDetails);
        processor.process(this.request, (EntityDetails)new BasicEntityDetails(1L, ContentType.APPLICATION_JSON), (HttpContext)context);
        String expectedValue = "by=" + remoteAddress.getAddress().getHostAddress() + ":" + remoteAddress.getPort() + ";for=" + localAddress.getAddress().getHostAddress() + ":" + localAddress.getPort() + ";host=\"" + "somehost" + "\";port=" + 8888 + ";proto=" + version.getProtocol();
        Assertions.assertEquals((Object)expectedValue, (Object)this.request.getFirstHeader(FORWARDED_HEADER_NAME).getValue());
    }

    @Test
    void testProcessWithIPv6() throws IOException, HttpException {
        ForwardedRequest processor = new ForwardedRequest();
        InetSocketAddress remoteAddress = InetSocketAddress.createUnresolved("[2001:0db8:85a3:0000:0000:8a2e:0370:7334]", 12345);
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("[0:0:0:0:0:0:0:1]", 2263);
        EndpointDetails endpointDetails = (EndpointDetails)Mockito.mock(EndpointDetails.class);
        Mockito.when((Object)endpointDetails.getRemoteAddress()).thenReturn((Object)remoteAddress);
        Mockito.when((Object)endpointDetails.getLocalAddress()).thenReturn((Object)localAddress);
        String host = "somehost";
        int port = 8888;
        this.request.setAuthority(new URIAuthority("somehost", 8888));
        HttpVersion version = HttpVersion.HTTP_1_1;
        HttpCoreContext context = HttpCoreContext.create();
        context.setEndpointDetails(endpointDetails);
        processor.process(this.request, (EntityDetails)new BasicEntityDetails(1L, ContentType.APPLICATION_JSON), (HttpContext)context);
        String expectedValue = "by=" + remoteAddress.getHostName() + ":" + remoteAddress.getPort() + ";for=" + localAddress.getHostName() + ":" + localAddress.getPort() + ";host=\"" + "somehost" + "\";port=" + 8888 + ";proto=" + version.getProtocol();
        Assertions.assertEquals((Object)expectedValue, (Object)this.request.getFirstHeader(FORWARDED_HEADER_NAME).getValue());
    }

    @Test
    void testProcess_withNullEndpointDetails_shouldAddValidHeader() throws Exception {
        ForwardedRequest processor = new ForwardedRequest();
        String host = "somehost";
        int port = 8888;
        this.request.setAuthority(new URIAuthority("somehost", 8888));
        HttpVersion version = HttpVersion.HTTP_1_1;
        HttpCoreContext context = HttpCoreContext.create();
        context.setEndpointDetails(null);
        processor.process(this.request, (EntityDetails)new BasicEntityDetails(1L, ContentType.APPLICATION_JSON), (HttpContext)context);
        String expectedValue = "host=\"somehost\";port=8888;proto=" + version.getProtocol();
        Assertions.assertEquals((Object)expectedValue, (Object)this.request.getFirstHeader(FORWARDED_HEADER_NAME).getValue());
    }

    @Test
    void testWithForwardedHeader() throws Exception {
        ForwardedRequest processor = new ForwardedRequest();
        String host = "newhost";
        int port = 8888;
        this.request.setAuthority(new URIAuthority("newhost", 8888));
        HttpVersion version = HttpVersion.HTTP_1_1;
        HttpCoreContext context = HttpCoreContext.create();
        context.setEndpointDetails(null);
        String forwaredHeaderValue = "host=oldhost;port=8855;proto=HTTP";
        this.request.setHeader((Header)new BasicHeader(FORWARDED_HEADER_NAME, (Object)"host=oldhost;port=8855;proto=HTTP"));
        processor.process(this.request, (EntityDetails)new BasicEntityDetails(1L, ContentType.APPLICATION_JSON), (HttpContext)context);
        String expectedValue = "host=oldhost;port=8855;proto=HTTP, host=\"newhost\";port=8888;proto=" + version.getProtocol();
        Assertions.assertEquals((Object)expectedValue, (Object)this.request.getFirstHeader(FORWARDED_HEADER_NAME).getValue());
    }

    @Test
    void testProcessWithNullHttpRequest() {
        ForwardedRequest httpRequestModifier = new ForwardedRequest();
        Assertions.assertThrows(NullPointerException.class, () -> httpRequestModifier.process(null, null, this.context));
    }

    @Test
    void testProcessWithNullHttpContext() {
        ForwardedRequest httpRequestModifier = new ForwardedRequest();
        Assertions.assertThrows(NullPointerException.class, () -> httpRequestModifier.process(this.request, null, null));
    }

    @Test
    void testProcessWithNullAuthority() {
        ForwardedRequest httpRequestModifier = new ForwardedRequest();
        Assertions.assertThrows(ProtocolException.class, () -> httpRequestModifier.process(this.request, null, this.context));
    }
}

