/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestStringEntity {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};

    TestStringEntity() {
    }

    @Test
    void testBasics() throws Exception {
        String s = "Message content";
        try (StringEntity httpentity = new StringEntity("Message content", ContentType.TEXT_PLAIN);){
            byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
            Assertions.assertEquals((long)bytes.length, (long)httpentity.getContentLength());
            Assertions.assertNotNull((Object)httpentity.getContent());
            Assertions.assertTrue((boolean)httpentity.isRepeatable());
            Assertions.assertFalse((boolean)httpentity.isStreaming());
        }
    }

    @Test
    void testNullConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new StringEntity(null));
    }

    @Test
    void testDefaultContent() throws Exception {
        String s = "Message content";
        StringEntity httpentity = new StringEntity("Message content", ContentType.create((String)"text/csv", (String)"ANSI_X3.4-1968"));
        Assertions.assertEquals((Object)"text/csv; charset=US-ASCII", (Object)httpentity.getContentType());
        httpentity = new StringEntity("Message content", StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"text/plain; charset=US-ASCII", (Object)httpentity.getContentType());
        httpentity = new StringEntity("Message content");
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8", (Object)httpentity.getContentType());
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    void testNullCharset() throws Exception {
        String s = TestStringEntity.constructString(SWISS_GERMAN_HELLO);
        StringEntity httpentity = new StringEntity(s, ContentType.create((String)"text/plain", (Charset)null));
        Assertions.assertNotNull((Object)httpentity.getContentType());
        Assertions.assertEquals((Object)"text/plain", (Object)httpentity.getContentType());
        Assertions.assertEquals((Object)s, (Object)EntityUtils.toString((HttpEntity)httpentity));
        httpentity = new StringEntity(s, (Charset)null);
        Assertions.assertNotNull((Object)httpentity.getContentType());
        Assertions.assertEquals((Object)"text/plain", (Object)httpentity.getContentType());
        Assertions.assertEquals((Object)s, (Object)EntityUtils.toString((HttpEntity)httpentity));
    }

    @Test
    void testWriteTo() throws Exception {
        String s = "Message content";
        byte[] bytes = "Message content".getBytes(StandardCharsets.UTF_8);
        try (StringEntity httpentity = new StringEntity("Message content");){
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            httpentity.writeTo((OutputStream)out);
            byte[] bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            out = new ByteArrayOutputStream();
            httpentity.writeTo((OutputStream)out);
            bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            Assertions.assertThrows(NullPointerException.class, () -> httpentity.writeTo(null));
        }
    }
}

