/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBufferedHttpEntity {
    TestBufferedHttpEntity() {
    }

    @Test
    void testBufferingEntity() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        BufferedHttpEntity entity = new BufferedHttpEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), -1L, null));
        Assertions.assertEquals((long)bytes.length, (long)entity.getContentLength());
        Assertions.assertTrue((boolean)entity.isRepeatable());
        Assertions.assertFalse((boolean)entity.isChunked());
        Assertions.assertFalse((boolean)entity.isStreaming());
        Assertions.assertNotNull((Object)entity.getContent());
        Assertions.assertNotNull((Object)entity.getContent());
    }

    @Test
    void testWrappingEntity() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes, null, true);
        try (BufferedHttpEntity bufentity = new BufferedHttpEntity((HttpEntity)httpentity);){
            Assertions.assertEquals((long)bytes.length, (long)bufentity.getContentLength());
            Assertions.assertTrue((boolean)bufentity.isRepeatable());
            Assertions.assertTrue((boolean)bufentity.isChunked());
            Assertions.assertFalse((boolean)bufentity.isStreaming());
            Assertions.assertNotNull((Object)bufentity.getContent());
            Assertions.assertNotNull((Object)bufentity.getContent());
        }
    }

    @Test
    void testIllegalConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new BufferedHttpEntity(null));
    }

    @Test
    void testWriteToBuffered() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), -1L, null);
        try (BufferedHttpEntity bufentity = new BufferedHttpEntity((HttpEntity)httpentity);){
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bufentity.writeTo((OutputStream)out);
            byte[] bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            out = new ByteArrayOutputStream();
            bufentity.writeTo((OutputStream)out);
            bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            Assertions.assertThrows(NullPointerException.class, () -> bufentity.writeTo(null));
        }
    }

    @Test
    void testWriteToWrapped() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes, null);
        try (BufferedHttpEntity bufentity = new BufferedHttpEntity((HttpEntity)httpentity);){
            int i;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bufentity.writeTo((OutputStream)out);
            byte[] bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            out = new ByteArrayOutputStream();
            bufentity.writeTo((OutputStream)out);
            bytes2 = out.toByteArray();
            Assertions.assertNotNull((Object)bytes2);
            Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
            for (i = 0; i < bytes.length; ++i) {
                Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
            }
            Assertions.assertThrows(NullPointerException.class, () -> bufentity.writeTo(null));
        }
    }
}

