/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.impl.nio.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.nio.SessionOutputBufferImpl;
import org.apache.hc.core5.http.nio.SessionInputBuffer;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSessionInOutBuffers {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_HELLO = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    TestSessionInOutBuffers() {
    }

    private static WritableByteChannel newChannel(ByteArrayOutputStream outStream) {
        return Channels.newChannel(outStream);
    }

    private static ReadableByteChannel newChannel(byte[] bytes) {
        return Channels.newChannel(new ByteArrayInputStream(bytes));
    }

    private static ReadableByteChannel newChannel(String s, Charset charset) {
        return Channels.newChannel(new ByteArrayInputStream(s.getBytes(charset)));
    }

    private static ReadableByteChannel newChannel(String s) {
        return TestSessionInOutBuffers.newChannel(s, StandardCharsets.US_ASCII);
    }

    @Test
    void testReadLineChunks() throws Exception {
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(16, 16);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel("One\r\nTwo\r\nThree");
        inbuf.fill(channel);
        CharArrayBuffer line = new CharArrayBuffer(64);
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, false));
        Assertions.assertEquals((Object)"One", (Object)line.toString());
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, false));
        Assertions.assertEquals((Object)"Two", (Object)line.toString());
        line.clear();
        Assertions.assertFalse((boolean)inbuf.readLine(line, false));
        channel = TestSessionInOutBuffers.newChannel("\r\nFour");
        inbuf.fill(channel);
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, false));
        Assertions.assertEquals((Object)"Three", (Object)line.toString());
        inbuf.fill(channel);
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, true));
        Assertions.assertEquals((Object)"Four", (Object)line.toString());
        line.clear();
        Assertions.assertFalse((boolean)inbuf.readLine(line, true));
    }

    @Test
    void testLineLimit() throws Exception {
        String s = "LoooooooooooooooooooooooooOOOOOOOOOOOOOOOOOOoooooooooooooooooooooong line\r\n";
        CharArrayBuffer line = new CharArrayBuffer(64);
        SessionInputBufferImpl inbuf1 = new SessionInputBufferImpl(128, 128);
        ReadableByteChannel channel1 = TestSessionInOutBuffers.newChannel("LoooooooooooooooooooooooooOOOOOOOOOOOOOOOOOOoooooooooooooooooooooong line\r\n");
        inbuf1.fill(channel1);
        Assertions.assertTrue((boolean)inbuf1.readLine(line, false));
        line.clear();
        SessionInputBufferImpl inbuf2 = new SessionInputBufferImpl(128, 128, 10);
        ReadableByteChannel channel2 = TestSessionInOutBuffers.newChannel("LoooooooooooooooooooooooooOOOOOOOOOOOOOOOOOOoooooooooooooooooooooong line\r\n");
        inbuf2.fill(channel2);
        Assertions.assertThrows(MessageConstraintException.class, () -> TestSessionInOutBuffers.lambda$testLineLimit$0((SessionInputBuffer)inbuf2, line));
    }

    @Test
    void testLineLimitBufferFull() throws Exception {
        String s = "LoooooooooooooooooooooooooOOOOOOOOOOOOOOOOOOoooooooooooooooooooooong line\r\n";
        CharArrayBuffer line = new CharArrayBuffer(64);
        SessionInputBufferImpl inbuf1 = new SessionInputBufferImpl(32, 32);
        ReadableByteChannel channel1 = TestSessionInOutBuffers.newChannel("LoooooooooooooooooooooooooOOOOOOOOOOOOOOOOOOoooooooooooooooooooooong line\r\n");
        inbuf1.fill(channel1);
        Assertions.assertFalse((boolean)inbuf1.readLine(line, false));
        line.clear();
        SessionInputBufferImpl inbuf2 = new SessionInputBufferImpl(32, 32, 10);
        ReadableByteChannel channel2 = TestSessionInOutBuffers.newChannel("LoooooooooooooooooooooooooOOOOOOOOOOOOOOOOOOoooooooooooooooooooooong line\r\n");
        inbuf2.fill(channel2);
        Assertions.assertThrows(MessageConstraintException.class, () -> TestSessionInOutBuffers.lambda$testLineLimitBufferFull$1((SessionInputBuffer)inbuf2, line));
    }

    @Test
    void testWriteLineChunks() throws Exception {
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(16, 16);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(16, 16, 0);
        ReadableByteChannel inChannel = TestSessionInOutBuffers.newChannel("One\r\nTwo\r\nThree");
        inbuf.fill(inChannel);
        CharArrayBuffer line = new CharArrayBuffer(64);
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, false));
        Assertions.assertEquals((Object)"One", (Object)line.toString());
        outbuf.writeLine(line);
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, false));
        Assertions.assertEquals((Object)"Two", (Object)line.toString());
        outbuf.writeLine(line);
        line.clear();
        Assertions.assertFalse((boolean)inbuf.readLine(line, false));
        inChannel = TestSessionInOutBuffers.newChannel("\r\nFour");
        inbuf.fill(inChannel);
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, false));
        Assertions.assertEquals((Object)"Three", (Object)line.toString());
        outbuf.writeLine(line);
        inbuf.fill(inChannel);
        line.clear();
        Assertions.assertTrue((boolean)inbuf.readLine(line, true));
        Assertions.assertEquals((Object)"Four", (Object)line.toString());
        outbuf.writeLine(line);
        line.clear();
        Assertions.assertFalse((boolean)inbuf.readLine(line, true));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel outChannel = TestSessionInOutBuffers.newChannel(outStream);
        outbuf.flush(outChannel);
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"One\r\nTwo\r\nThree\r\nFour\r\n", (Object)s);
    }

    @Test
    void testNonASCIIWriteLine() throws Exception {
        String testString = "123\u010anew-header-from-some-header:injected-value";
        String expectedResult = "123?new-header-from-some-header:injected-value";
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16);
        chbuffer.clear();
        chbuffer.append("123\u010anew-header-from-some-header:injected-value");
        outbuf.writeLine(chbuffer);
        outbuf.writeLine(null);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel outChannel = TestSessionInOutBuffers.newChannel(outStream);
        outbuf.flush(outChannel);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(outStream.toByteArray());
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 16, 0);
        inbuf.fill(channel);
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"123?new-header-from-some-header:injected-value", (Object)chbuffer.toString());
    }

    @Test
    void testBasicReadWriteLine() throws Exception {
        String[] teststrs = new String[5];
        teststrs[0] = "Hello";
        teststrs[1] = "This string should be much longer than the size of the line buffer which is only 16 bytes for this test";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            buffer.append("123456789 ");
        }
        buffer.append("and stuff like that");
        teststrs[2] = buffer.toString();
        teststrs[3] = "";
        teststrs[4] = "And goodbye";
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16);
        for (String teststr : teststrs) {
            chbuffer.clear();
            chbuffer.append(teststr);
            outbuf.writeLine(chbuffer);
        }
        outbuf.writeLine(null);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel outChannel = TestSessionInOutBuffers.newChannel(outStream);
        outbuf.flush(outChannel);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(outStream.toByteArray());
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 16, 0);
        inbuf.fill(channel);
        for (String teststr : teststrs) {
            chbuffer.clear();
            inbuf.readLine(chbuffer, true);
            Assertions.assertEquals((Object)teststr, (Object)chbuffer.toString());
        }
        chbuffer.clear();
        Assertions.assertFalse((boolean)inbuf.readLine(chbuffer, true));
        chbuffer.clear();
        Assertions.assertFalse((boolean)inbuf.readLine(chbuffer, true));
    }

    @Test
    void testComplexReadWriteLine() throws Exception {
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16);
        outbuf.write(ByteBuffer.wrap(new byte[]{97, 10}));
        outbuf.write(ByteBuffer.wrap(new byte[]{13, 10}));
        outbuf.write(ByteBuffer.wrap(new byte[]{13, 13, 10}));
        outbuf.write(ByteBuffer.wrap(new byte[]{10}));
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 14; ++i) {
            buffer.append("a");
        }
        String s1 = buffer.toString();
        buffer.append("\r\n");
        outbuf.write(ByteBuffer.wrap(buffer.toString().getBytes(StandardCharsets.US_ASCII)));
        buffer.setLength(0);
        for (int i = 0; i < 15; ++i) {
            buffer.append("a");
        }
        String s2 = buffer.toString();
        buffer.append("\r\n");
        outbuf.write(ByteBuffer.wrap(buffer.toString().getBytes(StandardCharsets.US_ASCII)));
        buffer.setLength(0);
        for (int i = 0; i < 16; ++i) {
            buffer.append("a");
        }
        String s3 = buffer.toString();
        buffer.append("\r\n");
        outbuf.write(ByteBuffer.wrap(buffer.toString().getBytes(StandardCharsets.US_ASCII)));
        outbuf.write(ByteBuffer.wrap(new byte[]{97}));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel outChannel = TestSessionInOutBuffers.newChannel(outStream);
        outbuf.flush(outChannel);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(outStream.toByteArray());
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(1024, 16, 0);
        inbuf.fill(channel);
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"a", (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"", (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"\r", (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"", (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)s1, (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)s2, (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)s3, (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"a", (Object)chbuffer.toString());
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertFalse((boolean)inbuf.readLine(chbuffer, true));
        chbuffer.clear();
        inbuf.readLine(chbuffer, true);
        Assertions.assertFalse((boolean)inbuf.readLine(chbuffer, true));
    }

    @Test
    void testReadOneByte() throws Exception {
        int i;
        byte[] out = new byte[40];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (byte)(48 + i2);
        }
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(out);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(16, 16, 0);
        while (inbuf.fill(channel) > 0) {
        }
        byte[] in = new byte[40];
        for (i = 0; i < in.length; ++i) {
            in[i] = (byte)inbuf.read();
        }
        for (i = 0; i < out.length; ++i) {
            Assertions.assertEquals((byte)out[i], (byte)in[i]);
        }
    }

    @Test
    void testReadByteBuffer() throws Exception {
        byte[] pattern = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(pattern);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(4096, 1024, 0);
        while (inbuf.fill(channel) > 0) {
        }
        ByteBuffer dst = ByteBuffer.allocate(10);
        Assertions.assertEquals((int)10, (int)inbuf.read(dst));
        dst.flip();
        Assertions.assertEquals((Object)dst, (Object)ByteBuffer.wrap(pattern, 0, 10));
        dst.clear();
        Assertions.assertEquals((int)6, (int)inbuf.read(dst));
        dst.flip();
        Assertions.assertEquals((Object)dst, (Object)ByteBuffer.wrap(pattern, 10, 6));
    }

    @Test
    void testReadByteBufferWithMaxLen() throws Exception {
        byte[] pattern = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(pattern);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(4096, 1024, 0);
        while (inbuf.fill(channel) > 0) {
        }
        ByteBuffer dst = ByteBuffer.allocate(16);
        Assertions.assertEquals((int)10, (int)inbuf.read(dst, 10));
        dst.flip();
        Assertions.assertEquals((Object)dst, (Object)ByteBuffer.wrap(pattern, 0, 10));
        dst.clear();
        Assertions.assertEquals((int)3, (int)inbuf.read(dst, 3));
        dst.flip();
        Assertions.assertEquals((Object)dst, (Object)ByteBuffer.wrap(pattern, 10, 3));
        Assertions.assertEquals((int)3, (int)inbuf.read(dst, 20));
        dst.flip();
        Assertions.assertEquals((Object)dst, (Object)ByteBuffer.wrap(pattern, 13, 3));
    }

    @Test
    void testReadToChannel() throws Exception {
        byte[] pattern = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(pattern);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(4096, 1024, 0);
        while (inbuf.fill(channel) > 0) {
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel dst = TestSessionInOutBuffers.newChannel(outStream);
        Assertions.assertEquals((int)16, (int)inbuf.read(dst));
        Assertions.assertEquals((Object)ByteBuffer.wrap(pattern), (Object)ByteBuffer.wrap(outStream.toByteArray()));
    }

    @Test
    void testReadToChannelWithMaxLen() throws Exception {
        byte[] pattern = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(pattern);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(4096, 1024, 0);
        while (inbuf.fill(channel) > 0) {
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel dst = TestSessionInOutBuffers.newChannel(outStream);
        Assertions.assertEquals((int)10, (int)inbuf.read(dst, 10));
        Assertions.assertEquals((int)3, (int)inbuf.read(dst, 3));
        Assertions.assertEquals((int)3, (int)inbuf.read(dst, 10));
        Assertions.assertEquals((Object)ByteBuffer.wrap(pattern), (Object)ByteBuffer.wrap(outStream.toByteArray()));
    }

    @Test
    void testWriteByteBuffer() throws Exception {
        byte[] pattern = "0123456789ABCDEF0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(4096, 1024);
        ReadableByteChannel src = TestSessionInOutBuffers.newChannel(pattern);
        outbuf.write(src);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel channel = TestSessionInOutBuffers.newChannel(outStream);
        while (outbuf.flush(channel) > 0) {
        }
        Assertions.assertEquals((Object)ByteBuffer.wrap(pattern), (Object)ByteBuffer.wrap(outStream.toByteArray()));
    }

    @Test
    void testWriteFromChannel() throws Exception {
        byte[] pattern = "0123456789ABCDEF0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(4096, 1024);
        outbuf.write(ByteBuffer.wrap(pattern, 0, 16));
        outbuf.write(ByteBuffer.wrap(pattern, 16, 10));
        outbuf.write(ByteBuffer.wrap(pattern, 26, 6));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel channel = TestSessionInOutBuffers.newChannel(outStream);
        while (outbuf.flush(channel) > 0) {
        }
        Assertions.assertEquals((Object)ByteBuffer.wrap(pattern), (Object)ByteBuffer.wrap(outStream.toByteArray()));
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    void testMultibyteCodedReadWriteLine() throws Exception {
        String s1 = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        String s2 = TestSessionInOutBuffers.constructString(RUSSIAN_HELLO);
        String s3 = "Like hello and stuff";
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16, StandardCharsets.UTF_8.newEncoder());
        CharArrayBuffer chbuffer = new CharArrayBuffer(32);
        for (int i = 0; i < 10; ++i) {
            chbuffer.clear();
            chbuffer.append(s1);
            outbuf.writeLine(chbuffer);
            chbuffer.clear();
            chbuffer.append(s2);
            outbuf.writeLine(chbuffer);
            chbuffer.clear();
            chbuffer.append("Like hello and stuff");
            outbuf.writeLine(chbuffer);
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        WritableByteChannel outChannel = TestSessionInOutBuffers.newChannel(outStream);
        outbuf.flush(outChannel);
        byte[] tmp = outStream.toByteArray();
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(tmp);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(16, 16, 0, StandardCharsets.UTF_8.newDecoder());
        while (inbuf.fill(channel) > 0) {
        }
        for (int i = 0; i < 10; ++i) {
            chbuffer.clear();
            inbuf.readLine(chbuffer, true);
            Assertions.assertEquals((Object)s1, (Object)chbuffer.toString());
            chbuffer.clear();
            inbuf.readLine(chbuffer, true);
            Assertions.assertEquals((Object)s2, (Object)chbuffer.toString());
            chbuffer.clear();
            inbuf.readLine(chbuffer, true);
            Assertions.assertEquals((Object)"Like hello and stuff", (Object)chbuffer.toString());
        }
    }

    @Test
    void testInputMatchesBufferLength() {
        String s1 = "abcde";
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 5);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("abcde");
        Assertions.assertDoesNotThrow(() -> TestSessionInOutBuffers.lambda$testInputMatchesBufferLength$2((SessionOutputBuffer)outbuf, chbuffer));
    }

    @Test
    void testMalformedInputActionReport() throws Exception {
        String s = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        byte[] tmp = s.getBytes(StandardCharsets.ISO_8859_1);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(16, 16, 0, decoder);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(tmp);
        while (inbuf.fill(channel) > 0) {
        }
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        Assertions.assertThrows(CharacterCodingException.class, () -> TestSessionInOutBuffers.lambda$testMalformedInputActionReport$3((SessionInputBuffer)inbuf, chbuffer));
    }

    @Test
    void testMalformedInputActionIgnore() throws Exception {
        String s = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        byte[] tmp = s.getBytes(StandardCharsets.ISO_8859_1);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(16, 16, 0, decoder);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(tmp);
        while (inbuf.fill(channel) > 0) {
        }
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"Grezi_zm", (Object)chbuffer.toString());
    }

    @Test
    void testMalformedInputActionReplace() throws Exception {
        String s = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        byte[] tmp = s.getBytes(StandardCharsets.ISO_8859_1);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferImpl inbuf = new SessionInputBufferImpl(16, 16, 0, decoder);
        ReadableByteChannel channel = TestSessionInOutBuffers.newChannel(tmp);
        while (inbuf.fill(channel) > 0) {
        }
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        inbuf.readLine(chbuffer, true);
        Assertions.assertEquals((Object)"Gr\ufffdezi_z\ufffdm\ufffd", (Object)chbuffer.toString());
    }

    @Test
    void testUnmappableInputActionReport() {
        String s = "This text contains a circumflex \u0302!!!";
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16, encoder);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("This text contains a circumflex \u0302!!!");
        Assertions.assertThrows(CharacterCodingException.class, () -> TestSessionInOutBuffers.lambda$testUnmappableInputActionReport$4((SessionOutputBuffer)outbuf, chbuffer));
    }

    @Test
    void testUnmappableInputActionIgnore() throws Exception {
        String s = "This text contains a circumflex \u0302!!!";
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16, encoder);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel channel = TestSessionInOutBuffers.newChannel(baos);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("This text contains a circumflex \u0302!!!");
        outbuf.writeLine(chbuffer);
        outbuf.flush(channel);
        String result = new String(baos.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"This text contains a circumflex !!!\r\n", (Object)result);
    }

    @Test
    void testUnmappableInputActionReplace() throws Exception {
        String s = "This text contains a circumflex \u0302 !!!";
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16, encoder);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel channel = TestSessionInOutBuffers.newChannel(baos);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append("This text contains a circumflex \u0302 !!!");
        outbuf.writeLine(chbuffer);
        outbuf.flush(channel);
        String result = new String(baos.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"This text contains a circumflex ? !!!\r\n", (Object)result);
    }

    private static /* synthetic */ void lambda$testUnmappableInputActionReport$4(SessionOutputBuffer outbuf, CharArrayBuffer chbuffer) throws Throwable {
        outbuf.writeLine(chbuffer);
    }

    private static /* synthetic */ void lambda$testMalformedInputActionReport$3(SessionInputBuffer inbuf, CharArrayBuffer chbuffer) throws Throwable {
        inbuf.readLine(chbuffer, true);
    }

    private static /* synthetic */ void lambda$testInputMatchesBufferLength$2(SessionOutputBuffer outbuf, CharArrayBuffer chbuffer) throws Throwable {
        outbuf.writeLine(chbuffer);
    }

    private static /* synthetic */ void lambda$testLineLimitBufferFull$1(SessionInputBuffer inbuf2, CharArrayBuffer line) throws Throwable {
        inbuf2.readLine(line, false);
    }

    private static /* synthetic */ void lambda$testLineLimit$0(SessionInputBuffer inbuf2, CharArrayBuffer line) throws Throwable {
        inbuf2.readLine(line, false);
    }
}

