/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;

public class ClassicFileServerExample {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Please specify document root directory");
            System.exit(1);
        }
        String docRoot = args[0];
        int port = 8080;
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        SSLContext sslContext = null;
        if (port == 8443) {
            URL url = ClassicFileServerExample.class.getResource("/my.keystore");
            if (url == null) {
                System.out.println("Keystore not found");
                System.exit(1);
            }
            sslContext = SSLContexts.custom().loadKeyMaterial(url, "secret".toCharArray(), "secret".toCharArray()).build();
        }
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(15, TimeUnit.SECONDS).setTcpNoDelay(true).build();
        HttpServer server = ServerBootstrap.bootstrap().setListenerPort(port).setSocketConfig(socketConfig).setSslContext(sslContext).setExceptionListener(new ExceptionListener(){

            public void onError(Exception ex) {
                ex.printStackTrace();
            }

            public void onError(HttpConnection conn, Exception ex) {
                if (ex instanceof SocketTimeoutException) {
                    System.err.println("Connection timed out");
                } else if (ex instanceof ConnectionClosedException) {
                    System.err.println(ex.getMessage());
                } else {
                    ex.printStackTrace();
                }
            }
        }).register("*", (HttpRequestHandler)new HttpFileHandler(docRoot)).create();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> server.close(CloseMode.GRACEFUL)));
        System.out.println("Listening on port " + port);
        server.awaitTermination(TimeValue.MAX_VALUE);
    }

    static class HttpFileHandler
    implements HttpRequestHandler {
        private final String docRoot;

        public HttpFileHandler(String docRoot) {
            this.docRoot = docRoot;
        }

        public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext localContext) throws HttpException, IOException {
            File file;
            HttpCoreContext context = HttpCoreContext.cast((HttpContext)localContext);
            String method = request.getMethod();
            if (!(Method.GET.isSame(method) || Method.HEAD.isSame(method) || Method.POST.isSame(method))) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            String path = request.getPath();
            HttpEntity incomingEntity = request.getEntity();
            if (incomingEntity != null) {
                byte[] entityContent = EntityUtils.toByteArray((HttpEntity)incomingEntity);
                System.out.println("Incoming incomingEntity content (bytes): " + entityContent.length);
            }
            if (!(file = new File(this.docRoot, URLDecoder.decode(path, "UTF-8"))).exists()) {
                response.setCode(404);
                String msg = "File " + file.getPath() + " not found";
                StringEntity outgoingEntity = new StringEntity("<html><body><h1>" + msg + "</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
                response.setEntity((HttpEntity)outgoingEntity);
                System.out.println(msg);
            } else if (!file.canRead() || file.isDirectory()) {
                response.setCode(403);
                String msg = "Cannot read file " + file.getPath();
                StringEntity outgoingEntity = new StringEntity("<html><body><h1>" + msg + "</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
                response.setEntity((HttpEntity)outgoingEntity);
                System.out.println(msg);
            } else {
                EndpointDetails endpoint = context.getEndpointDetails();
                response.setCode(200);
                FileEntity body = new FileEntity(file, ContentType.create((String)"text/html", (Charset)null));
                response.setEntity((HttpEntity)body);
                System.out.println(endpoint + ": serving file " + file.getPath());
            }
        }
    }
}

