/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHttpExceptions {
    private static final String CLEAN_MESSAGE = "[0x00]Hello[0x06][0x07][0x08][0x09][0x0a][0x0b][0x0c][0x0d][0x0e][0x0f]World";
    private static final String nonPrintableMessage = String.valueOf(new char[]{'\u0001', 'H', 'e', 'l', 'l', 'o', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', 'W', 'o', 'r', 'l', 'd'});

    TestHttpExceptions() {
    }

    @Test
    void testConstructor() {
        Exception cause = new Exception();
        Assertions.assertDoesNotThrow(() -> new HttpException());
        Assertions.assertDoesNotThrow(() -> new HttpException("Oppsie"));
        Assertions.assertDoesNotThrow(() -> new HttpException("Oppsie", cause));
        Assertions.assertDoesNotThrow(() -> new ProtocolException());
        Assertions.assertDoesNotThrow(() -> new ProtocolException("Oppsie"));
        Assertions.assertDoesNotThrow(() -> new ProtocolException("Oppsie", cause));
        Assertions.assertDoesNotThrow(() -> new NoHttpResponseException("Oppsie"));
        Assertions.assertDoesNotThrow(() -> new ConnectionClosedException("Oppsie"));
        Assertions.assertDoesNotThrow(() -> new MethodNotSupportedException("Oppsie"));
        Assertions.assertDoesNotThrow(() -> new MethodNotSupportedException("Oppsie", cause));
        Assertions.assertDoesNotThrow(() -> new UnsupportedHttpVersionException());
        Assertions.assertDoesNotThrow(() -> new UnsupportedHttpVersionException("Oppsie"));
    }

    @Test
    void testNonPrintableCharactersInConnectionClosedException() {
        Assertions.assertEquals((Object)CLEAN_MESSAGE, (Object)new ConnectionClosedException(nonPrintableMessage).getMessage());
    }

    @Test
    void testNonPrintableCharactersInHttpException() {
        Assertions.assertEquals((Object)CLEAN_MESSAGE, (Object)new HttpException(nonPrintableMessage).getMessage());
    }

    @Test
    void testNonPrintableCharactersInMethodNotSupportedException() {
        Assertions.assertEquals((Object)CLEAN_MESSAGE, (Object)new MethodNotSupportedException(nonPrintableMessage).getMessage());
    }

    @Test
    void testNonPrintableCharactersInNoHttpResponseException() {
        Assertions.assertEquals((Object)CLEAN_MESSAGE, (Object)new NoHttpResponseException(nonPrintableMessage).getMessage());
    }

    @Test
    void testNonPrintableCharactersInProtocolException() {
        Assertions.assertEquals((Object)CLEAN_MESSAGE, (Object)new ProtocolException(nonPrintableMessage).getMessage());
    }

    @Test
    void testNonPrintableCharactersInUnsupportedHttpVersionException() {
        Assertions.assertEquals((Object)CLEAN_MESSAGE, (Object)new UnsupportedHttpVersionException(nonPrintableMessage).getMessage());
    }
}

