/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorService;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;

abstract class IOReactorExecutor<T extends IOReactorService>
implements AutoCloseable {
    private final IOReactorConfig ioReactorConfig;
    private final ThreadFactory workerThreadFactory;
    private final AtomicReference<T> ioReactorRef;
    private final AtomicReference<Status> status;

    IOReactorExecutor(IOReactorConfig ioReactorConfig, ThreadFactory workerThreadFactory) {
        this.ioReactorConfig = ioReactorConfig != null ? ioReactorConfig : IOReactorConfig.DEFAULT;
        this.workerThreadFactory = workerThreadFactory;
        this.ioReactorRef = new AtomicReference();
        this.status = new AtomicReference<Status>(Status.READY);
    }

    abstract T createIOReactor(IOEventHandlerFactory var1, IOReactorConfig var2, ThreadFactory var3, Callback<IOSession> var4) throws IOException;

    protected void execute(IOEventHandlerFactory ioEventHandlerFactory) throws IOException {
        Args.notNull((Object)ioEventHandlerFactory, (String)"Handler factory");
        if (this.ioReactorRef.compareAndSet(null, this.createIOReactor(ioEventHandlerFactory, this.ioReactorConfig, this.workerThreadFactory, (Callback<IOSession>)ShutdownCommand.GRACEFUL_NORMAL_CALLBACK))) {
            if (this.status.compareAndSet(Status.READY, Status.RUNNING)) {
                ((IOReactorService)this.ioReactorRef.get()).start();
            }
        } else {
            throw new IllegalStateException("I/O reactor has already been started");
        }
    }

    private T ensureRunning() {
        IOReactorService ioReactor = (IOReactorService)this.ioReactorRef.get();
        Asserts.check((ioReactor != null ? 1 : 0) != 0, (String)"I/O reactor has not been started");
        return (T)ioReactor;
    }

    T reactor() {
        return this.ensureRunning();
    }

    public IOReactorStatus getStatus() {
        IOReactorService ioReactor = (IOReactorService)this.ioReactorRef.get();
        return ioReactor != null ? ioReactor.getStatus() : IOReactorStatus.INACTIVE;
    }

    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        Args.notNull((Object)waitTime, (String)"Wait time");
        IOReactorService ioReactor = (IOReactorService)this.ioReactorRef.get();
        if (ioReactor != null) {
            ioReactor.awaitShutdown(waitTime);
        }
    }

    public void initiateShutdown() {
        IOReactorService ioReactor = (IOReactorService)this.ioReactorRef.get();
        if (ioReactor != null && this.status.compareAndSet(Status.RUNNING, Status.TERMINATED)) {
            ioReactor.initiateShutdown();
        }
    }

    public void shutdown(TimeValue graceTime) {
        Args.notNull((Object)graceTime, (String)"Grace time");
        IOReactorService ioReactor = (IOReactorService)this.ioReactorRef.get();
        if (ioReactor != null) {
            if (this.status.compareAndSet(Status.RUNNING, Status.TERMINATED)) {
                ioReactor.initiateShutdown();
            }
            try {
                ioReactor.awaitShutdown(graceTime);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            ioReactor.close(CloseMode.IMMEDIATE);
        }
    }

    @Override
    public void close() throws Exception {
        this.shutdown(TimeValue.ofSeconds((long)5L));
    }

    static enum Status {
        READY,
        RUNNING,
        TERMINATED;

    }
}

