/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableZip<T, R>
extends Flowable<R> {
    final Publisher<? extends T>[] sources;
    final Iterable<? extends Publisher<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public FlowableZip(Publisher<? extends T>[] sources, Iterable<? extends Publisher<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s) {
        Publisher<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Publisher[8];
            for (Publisher<? extends T> publisher : this.sourcesIterable) {
                if (count == sources.length) {
                    Publisher[] b = new Publisher[count + (count >> 2)];
                    System.arraycopy(sources, 0, b, 0, count);
                    sources = b;
                }
                sources[count++] = publisher;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s);
            return;
        }
        ZipCoordinator<? extends T, R> coordinator = new ZipCoordinator<T, R>(s, this.zipper, count, this.bufferSize, this.delayError);
        s.onSubscribe(coordinator);
        coordinator.subscribe(sources, count);
    }

    static final class ZipSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4627193790118206028L;
        final ZipCoordinator<T, R> parent;
        final int prefetch;
        final int limit;
        SimpleQueue<T> queue;
        long produced;
        volatile boolean done;
        int sourceMode;

        ZipSubscriber(ZipCoordinator<T, R> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = f;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = f;
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.sourceMode != 2) {
                this.queue.offer(t);
            }
            this.parent.drain();
        }

        public void onError(Throwable t) {
            this.parent.error(this, t);
        }

        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void request(long n) {
            if (this.sourceMode != 1) {
                long p = this.produced + n;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = -2434867452883857743L;
        final Subscriber<? super R> downstream;
        final ZipSubscriber<T, R>[] subscribers;
        final Function<? super Object[], ? extends R> zipper;
        final AtomicLong requested;
        final AtomicThrowable errors;
        final boolean delayErrors;
        volatile boolean cancelled;
        final Object[] current;

        ZipCoordinator(Subscriber<? super R> actual, Function<? super Object[], ? extends R> zipper, int n, int prefetch, boolean delayErrors) {
            this.downstream = actual;
            this.zipper = zipper;
            this.delayErrors = delayErrors;
            ZipSubscriber[] a = new ZipSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new ZipSubscriber(this, prefetch);
            }
            this.current = new Object[n];
            this.subscribers = a;
            this.requested = new AtomicLong();
            this.errors = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T>[] sources, int n) {
            ZipSubscriber<T, R>[] a = this.subscribers;
            for (int i = 0; i < n; ++i) {
                if (this.cancelled || !this.delayErrors && this.errors.get() != null) {
                    return;
                }
                sources[i].subscribe(a[i]);
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
            }
        }

        void error(ZipSubscriber<T, R> inner, Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                inner.done = true;
                this.drain();
            }
        }

        void cancelAll() {
            for (ZipSubscriber<T, R> s : this.subscribers) {
                s.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<? super R> a = this.downstream;
            ZipSubscriber<T, R>[] qs = this.subscribers;
            int n = qs.length;
            Object[] values = this.current;
            int missed = 1;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; r != e; ++e) {
                    R v;
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(a);
                        return;
                    }
                    boolean empty = false;
                    for (int j = 0; j < n; ++j) {
                        boolean sourceEmpty;
                        ZipSubscriber<T, R> inner = qs[j];
                        if (values[j] != null) continue;
                        boolean d = inner.done;
                        SimpleQueue q = inner.queue;
                        Object v2 = null;
                        try {
                            v2 = q != null ? q.poll() : null;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.errors.tryAddThrowableOrReport(ex);
                            if (!this.delayErrors) {
                                this.cancelAll();
                                this.errors.tryTerminateConsumer(a);
                                return;
                            }
                            d = true;
                        }
                        boolean bl = sourceEmpty = v2 == null;
                        if (d && sourceEmpty) {
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(a);
                            return;
                        }
                        if (!sourceEmpty) {
                            values[j] = v2;
                            continue;
                        }
                        empty = true;
                    }
                    if (empty) break;
                    try {
                        v = Objects.requireNonNull(this.zipper.apply((Object[])values.clone()), "The zipper returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelAll();
                        this.errors.tryAddThrowableOrReport(ex);
                        this.errors.tryTerminateConsumer(a);
                        return;
                    }
                    a.onNext(v);
                    Arrays.fill(values, null);
                }
                if (r == e) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(a);
                        return;
                    }
                    for (int j = 0; j < n; ++j) {
                        boolean empty;
                        ZipSubscriber<T, R> inner = qs[j];
                        if (values[j] != null) continue;
                        boolean d = inner.done;
                        SimpleQueue q = inner.queue;
                        Object v = null;
                        try {
                            v = q != null ? q.poll() : null;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.errors.tryAddThrowableOrReport(ex);
                            if (!this.delayErrors) {
                                this.cancelAll();
                                this.errors.tryTerminateConsumer(a);
                                return;
                            }
                            d = true;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(a);
                            return;
                        }
                        if (empty) continue;
                        values[j] = v;
                    }
                }
                if (e == 0L) continue;
                for (ZipSubscriber<T, R> inner : qs) {
                    inner.request(e);
                }
                if (r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

