/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.as;

import java.io.FilterWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.flex.compiler.codegen.IDocEmitter;
import org.apache.flex.compiler.codegen.IEmitter;
import org.apache.flex.compiler.codegen.IEmitterTokens;
import org.apache.flex.compiler.codegen.as.IASEmitter;
import org.apache.flex.compiler.common.ASModifier;
import org.apache.flex.compiler.common.IImportTarget;
import org.apache.flex.compiler.common.ModifiersSet;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.IPackageDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.flex.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.flex.compiler.internal.tree.as.ContainerNode;
import org.apache.flex.compiler.internal.tree.as.FunctionNode;
import org.apache.flex.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IBinaryOperatorNode;
import org.apache.flex.compiler.tree.as.ICatchNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IConditionalNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IDynamicAccessNode;
import org.apache.flex.compiler.tree.as.IEmbedNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IForLoopNode;
import org.apache.flex.compiler.tree.as.IFunctionCallNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IFunctionObjectNode;
import org.apache.flex.compiler.tree.as.IGetterNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.IIfNode;
import org.apache.flex.compiler.tree.as.IImportNode;
import org.apache.flex.compiler.tree.as.IInterfaceNode;
import org.apache.flex.compiler.tree.as.IIterationFlowNode;
import org.apache.flex.compiler.tree.as.IKeywordNode;
import org.apache.flex.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.flex.compiler.tree.as.ILiteralContainerNode;
import org.apache.flex.compiler.tree.as.ILiteralNode;
import org.apache.flex.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.flex.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.flex.compiler.tree.as.INamespaceNode;
import org.apache.flex.compiler.tree.as.INumericLiteralNode;
import org.apache.flex.compiler.tree.as.IObjectLiteralValuePairNode;
import org.apache.flex.compiler.tree.as.IOperatorNode;
import org.apache.flex.compiler.tree.as.IPackageNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.IReturnNode;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.tree.as.ISetterNode;
import org.apache.flex.compiler.tree.as.IStatementNode;
import org.apache.flex.compiler.tree.as.ISwitchNode;
import org.apache.flex.compiler.tree.as.ITerminalNode;
import org.apache.flex.compiler.tree.as.ITernaryOperatorNode;
import org.apache.flex.compiler.tree.as.IThrowNode;
import org.apache.flex.compiler.tree.as.ITryNode;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.compiler.tree.as.ITypedExpressionNode;
import org.apache.flex.compiler.tree.as.IUnaryOperatorNode;
import org.apache.flex.compiler.tree.as.IUseNamespaceNode;
import org.apache.flex.compiler.tree.as.IVariableExpressionNode;
import org.apache.flex.compiler.tree.as.IVariableNode;
import org.apache.flex.compiler.tree.as.IWhileLoopNode;
import org.apache.flex.compiler.tree.as.IWithNode;
import org.apache.flex.compiler.tree.metadata.IMetaTagNode;
import org.apache.flex.compiler.utils.ASNodeUtils;
import org.apache.flex.compiler.visitor.IBlockWalker;
import org.apache.flex.compiler.visitor.as.IASBlockWalker;

public class ASEmitter
implements IASEmitter,
IEmitter {
    private final FilterWriter out;
    private IEmitter parentEmitter;
    private boolean bufferWrite;
    private StringBuilder builder;
    private int currentIndent = 0;
    private IASBlockWalker walker;
    private int currentLine = 0;
    private int currentColumn = 0;

    @Override
    public IEmitter getParentEmitter() {
        return this.parentEmitter;
    }

    @Override
    public void setParentEmitter(IEmitter value) {
        this.parentEmitter = value;
    }

    protected boolean isBufferWrite() {
        return this.bufferWrite;
    }

    public void setBufferWrite(boolean value) {
        this.bufferWrite = value;
    }

    protected StringBuilder getBuilder() {
        return this.builder;
    }

    protected void setBuilder(StringBuilder sb) {
        this.builder = sb;
    }

    protected void flushBuilder() {
        this.setBufferWrite(false);
        this.write(this.builder.toString());
        this.builder.setLength(0);
    }

    public List<ICompilerProblem> getProblems() {
        return this.walker.getErrors();
    }

    protected int getCurrentIndent() {
        return this.currentIndent;
    }

    protected void writeIndent() {
        this.write(ASEmitterTokens.INDENT);
    }

    @Override
    public IBlockWalker getWalker() {
        return this.walker;
    }

    @Override
    public void setWalker(IBlockWalker value) {
        this.walker = (IASBlockWalker)value;
    }

    @Override
    public IDocEmitter getDocEmitter() {
        return null;
    }

    @Override
    public void setDocEmitter(IDocEmitter value) {
    }

    protected int getCurrentLine() {
        return this.currentLine;
    }

    protected int getCurrentColumn() {
        return this.currentColumn;
    }

    public ASEmitter(FilterWriter out) {
        this.out = out;
        this.builder = new StringBuilder();
    }

    @Override
    public String postProcess(String output) {
        return output;
    }

    @Override
    public void write(IEmitterTokens value) {
        this.write(value.getToken());
    }

    @Override
    public void write(String value) {
        try {
            if (!this.bufferWrite) {
                if (this.parentEmitter != null) {
                    this.parentEmitter.write(value);
                } else {
                    int newLineCount = value.length() - value.replace("\n", "").length();
                    this.currentLine += newLineCount;
                    this.currentColumn = newLineCount > 0 ? value.length() - value.lastIndexOf("\n") - 1 : (this.currentColumn += value.length());
                    this.out.write(value);
                }
            } else {
                this.builder.append(value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(ASEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void indentPush() {
        ++this.currentIndent;
    }

    @Override
    public void indentPop() {
        --this.currentIndent;
    }

    @Override
    public void writeNewline() {
        this.write(ASEmitterTokens.NEW_LINE);
        this.write(this.getIndent(this.currentIndent));
    }

    @Override
    public void writeNewline(IEmitterTokens value) {
        this.writeNewline(value.getToken());
    }

    @Override
    public void writeNewline(String value) {
        this.write(value);
        this.writeNewline();
    }

    @Override
    public void writeNewline(IEmitterTokens value, boolean pushIndent) {
        this.writeNewline(value.getToken(), pushIndent);
    }

    @Override
    public void writeNewline(String value, boolean pushIndent) {
        if (pushIndent) {
            this.indentPush();
        } else {
            this.indentPop();
        }
        this.write(value);
        this.writeNewline();
    }

    public void writeSymbol(String value) {
        this.write(value);
    }

    @Override
    public void writeToken(IEmitterTokens value) {
        this.writeToken(value.getToken());
    }

    @Override
    public void writeToken(String value) {
        this.write(value);
        this.write(ASEmitterTokens.SPACE);
    }

    @Override
    public void emitImport(IImportNode node) {
        IImportTarget target = node.getImportTarget();
        this.writeToken(ASEmitterTokens.IMPORT);
        this.write(target.toString());
    }

    @Override
    public void emitPackageHeader(IPackageDefinition definition) {
        this.write(ASEmitterTokens.PACKAGE);
        IPackageNode node = definition.getNode();
        String name = node.getQualifiedName();
        if (name != null && !name.equals("")) {
            this.write(ASEmitterTokens.SPACE);
            this.getWalker().walk((IASNode)node.getNameExpressionNode());
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
    }

    @Override
    public void emitPackageHeaderContents(IPackageDefinition definition) {
    }

    @Override
    public void emitPackageContents(IPackageDefinition definition) {
        IPackageNode node = definition.getNode();
        ITypeNode tnode = EmitterUtils.findTypeNode(node);
        if (tnode != null) {
            this.indentPush();
            this.writeNewline();
            this.getWalker().walk((IASNode)tnode);
        }
    }

    @Override
    public void emitPackageFooter(IPackageDefinition definition) {
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    @Override
    public void emitClass(IClassNode node) {
        IExpressionNode[] inodes;
        int ilen;
        this.writeToken(node.getNamespace());
        if (node.hasModifier(ASModifier.FINAL)) {
            this.writeToken(ASEmitterTokens.FINAL);
        } else if (node.hasModifier(ASModifier.DYNAMIC)) {
            this.writeToken(ASEmitterTokens.DYNAMIC);
        }
        this.writeToken(ASEmitterTokens.CLASS);
        this.getWalker().walk((IASNode)node.getNameExpressionNode());
        this.write(ASEmitterTokens.SPACE);
        IExpressionNode bnode = node.getBaseClassExpressionNode();
        if (bnode != null) {
            this.writeToken(ASEmitterTokens.EXTENDS);
            this.getWalker().walk((IASNode)bnode);
            this.write(ASEmitterTokens.SPACE);
        }
        if ((ilen = (inodes = node.getImplementedInterfaceNodes()).length) != 0) {
            this.writeToken(ASEmitterTokens.IMPLEMENTS);
            for (int i = 0; i < ilen; ++i) {
                this.getWalker().walk((IASNode)inodes[i]);
                if (i >= ilen - 1) continue;
                this.writeToken(ASEmitterTokens.COMMA);
            }
            this.write(ASEmitterTokens.SPACE);
        }
        this.write(ASEmitterTokens.BLOCK_OPEN);
        IDefinitionNode[] members = node.getAllMemberNodes();
        if (members.length > 0) {
            this.indentPush();
            this.writeNewline();
            int len = members.length;
            int i = 0;
            for (IDefinitionNode mnode : members) {
                this.getWalker().walk((IASNode)mnode);
                if (mnode.getNodeID() == ASTNodeID.VariableID) {
                    this.write(ASEmitterTokens.SEMICOLON);
                    if (i < len - 1) {
                        this.writeNewline();
                    }
                } else if (mnode.getNodeID() == ASTNodeID.FunctionID) {
                    if (i < len - 1) {
                        this.writeNewline();
                    }
                } else if ((mnode.getNodeID() == ASTNodeID.GetterID || mnode.getNodeID() == ASTNodeID.SetterID) && i < len - 1) {
                    this.writeNewline();
                }
                ++i;
            }
            this.indentPop();
        }
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    @Override
    public void emitInterface(IInterfaceNode node) {
        this.writeToken(node.getNamespace());
        this.writeToken(ASEmitterTokens.INTERFACE);
        this.getWalker().walk((IASNode)node.getNameExpressionNode());
        this.write(ASEmitterTokens.SPACE);
        IExpressionNode[] inodes = node.getExtendedInterfaceNodes();
        int ilen = inodes.length;
        if (ilen != 0) {
            this.writeToken(ASEmitterTokens.EXTENDS);
            for (int i = 0; i < ilen; ++i) {
                this.getWalker().walk((IASNode)inodes[i]);
                if (i >= ilen - 1) continue;
                this.writeToken(ASEmitterTokens.COMMA);
            }
            this.write(ASEmitterTokens.SPACE);
        }
        this.write(ASEmitterTokens.BLOCK_OPEN);
        IDefinitionNode[] members = node.getAllMemberDefinitionNodes();
        if (members.length > 0) {
            this.indentPush();
            this.writeNewline();
            int len = members.length;
            int i = 0;
            for (IDefinitionNode mnode : members) {
                this.getWalker().walk((IASNode)mnode);
                this.write(ASEmitterTokens.SEMICOLON);
                if (i < len - 1) {
                    this.writeNewline();
                }
                ++i;
            }
            this.indentPop();
        }
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    @Override
    public void emitVarDeclaration(IVariableNode node) {
        if (!(node instanceof ChainedVariableNode)) {
            this.emitMemberKeyword((IDefinitionNode)node);
        }
        this.emitDeclarationName((IDefinitionNode)node);
        this.emitType(node.getVariableTypeNode());
        IExpressionNode avnode = node.getAssignedValueNode();
        if (avnode != null) {
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.emitAssignedValue(avnode);
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeToken(ASEmitterTokens.COMMA);
                this.emitVarDeclaration((IVariableNode)child);
            }
        }
    }

    @Override
    public void emitFieldDocumentation(IVariableNode node) {
    }

    @Override
    public void emitField(IVariableNode node) {
        this.emitFieldDocumentation(node);
        IVariableDefinition definition = (IVariableDefinition)node.getDefinition();
        if (!(node instanceof ChainedVariableNode)) {
            this.emitNamespaceIdentifier((IDefinitionNode)node);
            this.emitModifiers((IDefinition)definition);
            this.emitMemberKeyword((IDefinitionNode)node);
        }
        this.emitMemberName((IDefinitionNode)node);
        this.emitType(node.getVariableTypeNode());
        IExpressionNode avnode = node.getAssignedValueNode();
        if (avnode != null) {
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.emitAssignedValue(avnode);
        }
        if (!(node instanceof ChainedVariableNode)) {
            int len = node.getChildCount();
            for (int i = 0; i < len; ++i) {
                IASNode child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                this.writeToken(ASEmitterTokens.COMMA);
                this.emitField((IVariableNode)child);
            }
        }
    }

    @Override
    public void emitMethodDocumentation(IFunctionNode node) {
    }

    @Override
    public void emitMethod(IFunctionNode node) {
        if (node instanceof IGetterNode) {
            this.emitGetAccessorDocumentation((IGetterNode)node);
        } else if (node instanceof ISetterNode) {
            this.emitSetAccessorDocumentation((ISetterNode)node);
        } else {
            this.emitMethodDocumentation(node);
        }
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(this.getProblems());
        IFunctionDefinition definition = node.getDefinition();
        this.emitNamespaceIdentifier((IDefinitionNode)node);
        this.emitModifiers((IDefinition)definition);
        this.emitMemberKeyword((IDefinitionNode)node);
        if (node instanceof IAccessorNode) {
            this.emitAccessorKeyword(((IAccessorNode)node).getAccessorKeywordNode());
        }
        this.emitMemberName((IDefinitionNode)node);
        this.emitParameters(node.getParametersContainerNode());
        this.emitType(node.getReturnTypeNode());
        if (node.getParent().getParent().getNodeID() == ASTNodeID.ClassID) {
            this.emitMethodScope(node.getScopedNode());
        }
    }

    @Override
    public void emitGetAccessorDocumentation(IGetterNode node) {
    }

    @Override
    public void emitGetAccessor(IGetterNode node) {
        this.emitMethod((IFunctionNode)node);
    }

    @Override
    public void emitSetAccessorDocumentation(ISetterNode node) {
    }

    @Override
    public void emitSetAccessor(ISetterNode node) {
        this.emitMethod((IFunctionNode)node);
    }

    @Override
    public void emitLocalNamedFunction(IFunctionNode node) {
        FunctionNode fnode = (FunctionNode)node;
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.SPACE);
        this.write(fnode.getName());
        this.emitParameters((IContainerNode)fnode.getParametersContainerNode());
        this.emitType((IExpressionNode)fnode.getTypeNode());
        this.emitFunctionScope((IScopedNode)fnode.getScopedNode());
    }

    @Override
    public void emitFunctionObject(IFunctionObjectNode node) {
        FunctionNode fnode = node.getFunctionNode();
        this.write(ASEmitterTokens.FUNCTION);
        this.emitParameters((IContainerNode)fnode.getParametersContainerNode());
        this.emitType((IExpressionNode)fnode.getTypeNode());
        this.emitFunctionScope((IScopedNode)fnode.getScopedNode());
    }

    @Override
    public void emitNamespace(INamespaceNode node) {
        this.emitNamespaceIdentifier((IDefinitionNode)node);
        this.writeToken(ASEmitterTokens.NAMESPACE);
        this.emitMemberName((IDefinitionNode)node);
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.getWalker().walk((IASNode)node.getNamespaceURINode());
    }

    protected void emitNamespaceIdentifier(IDefinitionNode node) {
        String namespace = node.getNamespace();
        if (namespace != null && !namespace.equals("internal")) {
            this.writeToken(namespace);
        }
    }

    protected void emitModifiers(IDefinition definition) {
        ModifiersSet modifierSet = definition.getModifiers();
        if (modifierSet.hasModifiers()) {
            for (ASModifier modifier : modifierSet.getAllModifiers()) {
                this.writeToken(modifier.toString());
            }
        }
    }

    public void emitMemberKeyword(IDefinitionNode node) {
        if (node instanceof IFunctionNode) {
            this.writeToken(ASEmitterTokens.FUNCTION);
        } else if (node instanceof IVariableNode) {
            this.writeToken(((IVariableNode)node).isConst() ? ASEmitterTokens.CONST : ASEmitterTokens.VAR);
        }
    }

    protected void emitMemberName(IDefinitionNode node) {
        this.getWalker().walk((IASNode)node.getNameExpressionNode());
    }

    public void emitDeclarationName(IDefinitionNode node) {
        this.getWalker().walk((IASNode)node.getNameExpressionNode());
    }

    public void emitParameters(IContainerNode node) {
        this.write(ASEmitterTokens.PAREN_OPEN);
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IParameterNode parameterNode = (IParameterNode)node.getChild(i);
            this.getWalker().walk((IASNode)parameterNode);
            if (i >= len - 1) continue;
            this.writeToken(ASEmitterTokens.COMMA);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    @Override
    public void emitParameter(IParameterNode node) {
        if (node.isRest()) {
            this.write(ASEmitterTokens.ELLIPSIS);
            this.write(node.getName());
        } else {
            this.getWalker().walk((IASNode)node.getNameExpressionNode());
            this.write(ASEmitterTokens.COLON);
            this.getWalker().walk((IASNode)node.getVariableTypeNode());
            IExpressionNode anode = node.getAssignedValueNode();
            if (anode != null) {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.getWalker().walk((IASNode)anode);
            }
        }
    }

    protected void emitType(IExpressionNode node) {
        if (node != null) {
            this.write(ASEmitterTokens.COLON);
            this.getWalker().walk((IASNode)node);
        }
    }

    protected void emitAssignedValue(IExpressionNode node) {
        if (node == null) {
            return;
        }
        this.getWalker().walk((IASNode)node);
    }

    @Override
    public void emitFunctionBlockHeader(IFunctionNode node) {
    }

    public void emitMethodScope(IScopedNode node) {
        this.write(ASEmitterTokens.SPACE);
        this.getWalker().walk((IASNode)node);
    }

    protected void emitAccessorKeyword(IKeywordNode node) {
        this.getWalker().walk((IASNode)node);
        this.write(ASEmitterTokens.SPACE);
    }

    protected void emitFunctionScope(IScopedNode node) {
        this.emitMethodScope(node);
    }

    @Override
    public void emitStatement(IASNode node) {
        this.getWalker().walk(node);
        if (node.getParent().getNodeID() != ASTNodeID.LabledStatementID && node.getNodeID() != ASTNodeID.ConfigBlockID && !(node instanceof IStatementNode)) {
            this.write(ASEmitterTokens.SEMICOLON);
        }
        if (!ASEmitter.isLastStatement(node)) {
            this.writeNewline();
        }
    }

    @Override
    public void emitIf(IIfNode node) {
        ITerminalNode elseNode;
        IConditionalNode conditional = (IConditionalNode)node.getChild(0);
        IContainerNode xnode = (IContainerNode)conditional.getStatementContentsNode();
        this.writeToken(ASEmitterTokens.IF);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk(conditional.getChild(0));
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (!ASEmitter.isImplicit(xnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.getWalker().walk(conditional.getChild(1));
        IConditionalNode[] nodes = node.getElseIfNodes();
        if (nodes.length > 0) {
            for (int i = 0; i < nodes.length; ++i) {
                IConditionalNode enode = nodes[i];
                IContainerNode snode = (IContainerNode)enode.getStatementContentsNode();
                boolean isImplicit = ASEmitter.isImplicit(snode);
                if (isImplicit) {
                    this.writeNewline();
                } else {
                    this.write(ASEmitterTokens.SPACE);
                }
                this.writeToken(ASEmitterTokens.ELSE);
                this.writeToken(ASEmitterTokens.IF);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.getWalker().walk(enode.getChild(0));
                this.write(ASEmitterTokens.PAREN_CLOSE);
                if (!isImplicit) {
                    this.write(ASEmitterTokens.SPACE);
                }
                this.getWalker().walk(enode.getChild(1));
            }
        }
        if ((elseNode = node.getElseNode()) != null) {
            IContainerNode cnode = (IContainerNode)elseNode.getChild(0);
            boolean isImplicit = ASEmitter.isImplicit(cnode);
            if (isImplicit) {
                this.writeNewline();
            } else {
                this.write(ASEmitterTokens.SPACE);
            }
            this.write(ASEmitterTokens.ELSE);
            if (!isImplicit) {
                this.write(ASEmitterTokens.SPACE);
            }
            this.getWalker().walk((IASNode)elseNode);
        }
    }

    @Override
    public void emitForEachLoop(IForLoopNode node) {
        IContainerNode xnode = (IContainerNode)node.getChild(1);
        this.writeToken(ASEmitterTokens.FOR);
        this.writeToken(ASEmitterTokens.EACH);
        this.write(ASEmitterTokens.PAREN_OPEN);
        IContainerNode cnode = node.getConditionalsContainerNode();
        this.getWalker().walk(cnode.getChild(0));
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (!ASEmitter.isImplicit(xnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.getWalker().walk(node.getStatementContentsNode());
    }

    @Override
    public void emitForLoop(IForLoopNode node) {
        IContainerNode xnode = (IContainerNode)node.getChild(1);
        this.writeToken(ASEmitterTokens.FOR);
        this.write(ASEmitterTokens.PAREN_OPEN);
        IContainerNode cnode = node.getConditionalsContainerNode();
        IASNode node0 = cnode.getChild(0);
        if (node0.getNodeID() == ASTNodeID.Op_InID) {
            this.getWalker().walk(cnode.getChild(0));
        } else {
            this.visitForBody(cnode);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (!ASEmitter.isImplicit(xnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.getWalker().walk(node.getStatementContentsNode());
    }

    @Override
    public void emitSwitch(ISwitchNode node) {
        this.writeToken(ASEmitterTokens.SWITCH);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk(node.getChild(0));
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.writeNewline(ASEmitterTokens.BLOCK_OPEN, true);
        IConditionalNode[] cnodes = ASNodeUtils.getCaseNodes(node);
        ITerminalNode dnode = ASNodeUtils.getDefaultNode(node);
        for (int i = 0; i < cnodes.length; ++i) {
            IConditionalNode casen = cnodes[i];
            IContainerNode cnode = (IContainerNode)casen.getChild(1);
            this.writeToken(ASEmitterTokens.CASE);
            this.getWalker().walk((IASNode)casen.getConditionalExpressionNode());
            this.write(ASEmitterTokens.COLON);
            if (!ASEmitter.isImplicit(cnode)) {
                this.write(ASEmitterTokens.SPACE);
            }
            this.getWalker().walk(casen.getStatementContentsNode());
            if (i == cnodes.length - 1 && dnode == null) {
                this.indentPop();
                this.writeNewline();
                continue;
            }
            this.writeNewline();
        }
        if (dnode != null) {
            IContainerNode cnode = (IContainerNode)dnode.getChild(0);
            this.write(ASEmitterTokens.DEFAULT);
            this.write(ASEmitterTokens.COLON);
            if (!ASEmitter.isImplicit(cnode)) {
                this.write(ASEmitterTokens.SPACE);
            }
            this.getWalker().walk((IASNode)dnode);
            this.indentPop();
            this.writeNewline();
        }
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    @Override
    public void emitWhileLoop(IWhileLoopNode node) {
        IContainerNode cnode = (IContainerNode)node.getChild(1);
        this.writeToken(ASEmitterTokens.WHILE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)node.getConditionalExpressionNode());
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (!ASEmitter.isImplicit(cnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.getWalker().walk(node.getStatementContentsNode());
    }

    @Override
    public void emitDoLoop(IWhileLoopNode node) {
        IContainerNode cnode = (IContainerNode)node.getChild(0);
        this.write(ASEmitterTokens.DO);
        if (!ASEmitter.isImplicit(cnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.getWalker().walk(node.getStatementContentsNode());
        if (!ASEmitter.isImplicit(cnode)) {
            this.write(ASEmitterTokens.SPACE);
        } else {
            this.writeNewline();
        }
        this.write(ASEmitterTokens.WHILE);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)node.getConditionalExpressionNode());
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
    }

    @Override
    public void emitWith(IWithNode node) {
        IContainerNode cnode = (IContainerNode)node.getChild(1);
        this.writeToken(ASEmitterTokens.WITH);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)node.getTargetNode());
        this.write(ASEmitterTokens.PAREN_CLOSE);
        if (!ASEmitter.isImplicit(cnode)) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.getWalker().walk(node.getStatementContentsNode());
    }

    @Override
    public void emitThrow(IThrowNode node) {
        this.writeToken(ASEmitterTokens.THROW);
        this.getWalker().walk((IASNode)node.getThrownExpressionNode());
    }

    @Override
    public void emitTry(ITryNode node) {
        this.writeToken(ASEmitterTokens.TRY);
        this.getWalker().walk(node.getStatementContentsNode());
        for (int i = 0; i < node.getCatchNodeCount(); ++i) {
            this.getWalker().walk((IASNode)node.getCatchNode(i));
        }
        ITerminalNode fnode = node.getFinallyNode();
        if (fnode != null) {
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.FINALLY);
            this.getWalker().walk((IASNode)fnode);
        }
    }

    @Override
    public void emitCatch(ICatchNode node) {
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.CATCH);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.getWalker().walk((IASNode)node.getCatchParameterNode());
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.getWalker().walk(node.getStatementContentsNode());
    }

    @Override
    public void emitReturn(IReturnNode node) {
        this.write(ASEmitterTokens.RETURN);
        IExpressionNode rnode = node.getReturnValueNode();
        if (rnode != null && rnode.getNodeID() != ASTNodeID.NilID) {
            this.write(ASEmitterTokens.SPACE);
            this.getWalker().walk((IASNode)rnode);
        }
    }

    @Override
    public void emitFunctionCall(IFunctionCallNode node) {
        if (node.isNewExpression()) {
            this.writeToken(ASEmitterTokens.NEW);
        }
        this.getWalker().walk((IASNode)node.getNameNode());
        this.emitArguments((IContainerNode)node.getArgumentsNode());
    }

    @Override
    public void emitArguments(IContainerNode node) {
        this.write(ASEmitterTokens.PAREN_OPEN);
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IExpressionNode argumentNode = (IExpressionNode)node.getChild(i);
            this.getWalker().walk((IASNode)argumentNode);
            if (i >= len - 1) continue;
            this.writeToken(ASEmitterTokens.COMMA);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    @Override
    public void emitAsOperator(IBinaryOperatorNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(node.getOperator().getOperatorText());
        this.getWalker().walk((IASNode)node.getRightOperandNode());
    }

    @Override
    public void emitIsOperator(IBinaryOperatorNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(node.getOperator().getOperatorText());
        this.getWalker().walk((IASNode)node.getRightOperandNode());
    }

    @Override
    public void emitBinaryOperator(IBinaryOperatorNode node) {
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        if (node.getNodeID() != ASTNodeID.Op_CommaID) {
            this.write(ASEmitterTokens.SPACE);
        }
        this.writeToken(node.getOperator().getOperatorText());
        this.getWalker().walk((IASNode)node.getRightOperandNode());
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    protected ITypeNode findTypeNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof ITypeNode)) continue;
            return (ITypeNode)child;
        }
        return null;
    }

    protected ITypeDefinition findType(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof ITypeDefinition)) continue;
            return (ITypeDefinition)definition;
        }
        return null;
    }

    protected static IFunctionNode getConstructor(IDefinitionNode[] members) {
        for (IDefinitionNode node : members) {
            IFunctionNode fnode;
            if (!(node instanceof IFunctionNode) || !(fnode = (IFunctionNode)node).isConstructor()) continue;
            return fnode;
        }
        return null;
    }

    protected static boolean isLastStatement(IASNode node) {
        return ASEmitter.getChildIndex(node.getParent(), node) == node.getParent().getChildCount() - 1;
    }

    private static int getChildIndex(IASNode parent, IASNode node) {
        int len = parent.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (parent.getChild(i) != node) continue;
            return i;
        }
        return -1;
    }

    protected static final boolean isImplicit(IContainerNode node) {
        return EmitterUtils.isImplicit(node);
    }

    protected void visitForBody(IContainerNode node) {
        IASNode node0 = node.getChild(0);
        IASNode node1 = node.getChild(1);
        IASNode node2 = node.getChild(2);
        if (node0 != null) {
            this.getWalker().walk(node0);
            this.write(ASEmitterTokens.SEMICOLON);
            if (node1.getNodeID() != ASTNodeID.NilID) {
                this.write(ASEmitterTokens.SPACE);
            }
        }
        if (node1 != null) {
            this.getWalker().walk(node1);
            this.write(ASEmitterTokens.SEMICOLON);
            if (node2.getNodeID() != ASTNodeID.NilID) {
                this.write(ASEmitterTokens.SPACE);
            }
        }
        if (node2 != null) {
            this.getWalker().walk(node2);
        }
    }

    @Override
    public void emitLiteral(ILiteralNode node) {
        this.write(node.getValue(true));
    }

    @Override
    public void emitLiteralContainer(ILiteralContainerNode node) {
        ContainerNode cnode = node.getContentsNode();
        IContainerNode.ContainerType type = cnode.getContainerType();
        String postFix = "";
        if (type == IContainerNode.ContainerType.BRACES) {
            this.write(ASEmitterTokens.BLOCK_OPEN);
            postFix = ASEmitterTokens.BLOCK_CLOSE.getToken();
        } else if (type == IContainerNode.ContainerType.BRACKETS) {
            this.write(ASEmitterTokens.SQUARE_OPEN);
            postFix = ASEmitterTokens.SQUARE_CLOSE.getToken();
        } else if (type != IContainerNode.ContainerType.IMPLICIT && type == IContainerNode.ContainerType.PARENTHESIS) {
            this.write(ASEmitterTokens.PAREN_OPEN);
            postFix = ASEmitterTokens.PAREN_CLOSE.getToken();
        }
        int len = cnode.getChildCount();
        for (int i = 0; i < len; ++i) {
            IASNode child = cnode.getChild(i);
            this.getWalker().walk(child);
            if (i >= len - 1) continue;
            this.writeToken(ASEmitterTokens.COMMA);
        }
        if (postFix != "") {
            this.write(postFix);
        }
    }

    @Override
    public void emitIdentifier(IIdentifierNode node) {
        this.write(node.getName());
    }

    @Override
    public void emitNumericLiteral(INumericLiteralNode node) {
        this.write(node.getNumericValue().toString());
    }

    @Override
    public void emitKeyword(IKeywordNode node) {
        this.write(node.getNodeID().getParaphrase());
    }

    @Override
    public void emitIterationFlow(IIterationFlowNode node) {
        this.write(node.getKind().toString().toLowerCase());
        IIdentifierNode lnode = node.getLabelNode();
        if (lnode != null) {
            this.write(ASEmitterTokens.SPACE);
            this.getWalker().walk((IASNode)lnode);
        }
    }

    @Override
    public void emitMemberAccessExpression(IMemberAccessExpressionNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(node.getOperator().getOperatorText());
        this.getWalker().walk((IASNode)node.getRightOperandNode());
    }

    @Override
    public void emitDynamicAccess(IDynamicAccessNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(ASEmitterTokens.SQUARE_OPEN);
        this.getWalker().walk((IASNode)node.getRightOperandNode());
        this.write(ASEmitterTokens.SQUARE_CLOSE);
    }

    @Override
    public void emitTypedExpression(ITypedExpressionNode node) {
        this.getWalker().walk((IASNode)node.getCollectionNode());
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(ASEmitterTokens.LESS_THAN);
        this.getWalker().walk((IASNode)node.getTypeNode());
        this.write(ASEmitterTokens.GREATER_THAN);
    }

    @Override
    public void emitVariableExpression(IVariableExpressionNode node) {
        this.getWalker().walk((IASNode)node.getTargetVariable());
    }

    @Override
    public void emitTernaryOperator(ITernaryOperatorNode node) {
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        this.getWalker().walk((IASNode)node.getConditionalNode());
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.TERNARY);
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.COLON);
        this.getWalker().walk((IASNode)node.getRightOperandNode());
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    @Override
    public void emitObjectLiteralValuePair(IObjectLiteralValuePairNode node) {
        this.getWalker().walk((IASNode)node.getNameNode());
        this.write(ASEmitterTokens.COLON);
        this.getWalker().walk((IASNode)node.getValueNode());
    }

    @Override
    public void emitLabelStatement(LabeledStatementNode node) {
        this.writeToken(node.getLabel());
        this.writeToken(ASEmitterTokens.COLON);
        this.getWalker().walk((IASNode)node.getLabeledStatement());
    }

    @Override
    public void emitNamespaceAccessExpression(INamespaceAccessExpressionNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.write(node.getOperator().getOperatorText());
        this.getWalker().walk((IASNode)node.getRightOperandNode());
    }

    @Override
    public void emitUnaryOperator(IUnaryOperatorNode node) {
        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_OPEN);
        }
        if (node.getNodeID() == ASTNodeID.Op_PreIncrID || node.getNodeID() == ASTNodeID.Op_PreDecrID || node.getNodeID() == ASTNodeID.Op_BitwiseNotID || node.getNodeID() == ASTNodeID.Op_LogicalNotID || node.getNodeID() == ASTNodeID.Op_SubtractID || node.getNodeID() == ASTNodeID.Op_AddID) {
            this.write(node.getOperator().getOperatorText());
            IExpressionNode opNode = node.getOperandNode();
            this.getWalker().walk((IASNode)opNode);
        } else if (node.getNodeID() == ASTNodeID.Op_PostIncrID || node.getNodeID() == ASTNodeID.Op_PostDecrID) {
            this.getWalker().walk((IASNode)node.getOperandNode());
            this.write(node.getOperator().getOperatorText());
        } else if (node.getNodeID() == ASTNodeID.Op_DeleteID || node.getNodeID() == ASTNodeID.Op_VoidID) {
            this.writeToken(node.getOperator().getOperatorText());
            this.getWalker().walk((IASNode)node.getOperandNode());
        } else if (node.getNodeID() == ASTNodeID.Op_TypeOfID) {
            this.write(node.getOperator().getOperatorText());
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.getWalker().walk((IASNode)node.getOperandNode());
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
            this.write(ASEmitterTokens.PAREN_CLOSE);
        }
    }

    @Override
    public void emitLanguageIdentifier(ILanguageIdentifierNode node) {
        if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.ANY_TYPE) {
            this.write(ASEmitterTokens.ANY_TYPE);
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.REST) {
            this.write(ASEmitterTokens.ELLIPSIS);
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER) {
            this.write(ASEmitterTokens.SUPER);
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.THIS) {
            this.write(ASEmitterTokens.THIS);
        } else if (node.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.VOID) {
            this.write(ASEmitterTokens.VOID);
        }
    }

    @Override
    public void emitMetaTag(IMetaTagNode node) {
    }

    @Override
    public void emitEmbed(IEmbedNode node) {
    }

    @Override
    public void emitContainer(IContainerNode node) {
    }

    @Override
    public void emitE4XFilter(IMemberAccessExpressionNode node) {
    }

    @Override
    public void emitUseNamespace(IUseNamespaceNode node) {
    }

    @Override
    public void emitBlockOpen(IContainerNode node) {
        this.write(ASEmitterTokens.BLOCK_OPEN);
    }

    @Override
    public void emitBlockClose(IContainerNode node) {
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    @Override
    public String stringifyNode(IASNode node) {
        boolean oldBufferWrite = this.isBufferWrite();
        StringBuilder oldBuilder = this.builder;
        this.builder = new StringBuilder();
        this.setBufferWrite(true);
        this.getWalker().walk(node);
        String result = this.getBuilder().toString();
        this.getBuilder().setLength(0);
        this.builder = oldBuilder;
        this.setBufferWrite(oldBufferWrite);
        return result;
    }
}

