/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.units;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import org.apache.flex.compiler.css.ICSSDocument;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.apache.flex.compiler.internal.as.codegen.CodeGeneratorManager;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.parsing.as.OffsetCue;
import org.apache.flex.compiler.internal.parsing.as.OffsetLookup;
import org.apache.flex.compiler.internal.parsing.mxml.MXMLScopeBuilder;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.projects.DefinitionPriority;
import org.apache.flex.compiler.internal.projects.FlexProject;
import org.apache.flex.compiler.internal.scopes.MXMLFileScope;
import org.apache.flex.compiler.internal.scopes.TypeScope;
import org.apache.flex.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLFileNode;
import org.apache.flex.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.flex.compiler.internal.units.CompilationUnitBase;
import org.apache.flex.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.flex.compiler.internal.units.requests.ASFileScopeRequestResult;
import org.apache.flex.compiler.internal.units.requests.SWFTagsRequestResult;
import org.apache.flex.compiler.internal.units.requests.SyntaxTreeRequestResult;
import org.apache.flex.compiler.mxml.IMXMLData;
import org.apache.flex.compiler.mxml.IMXMLDataManager;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.UnexpectedExceptionProblem;
import org.apache.flex.compiler.tree.mxml.IMXMLFileNode;
import org.apache.flex.compiler.tree.mxml.IMXMLStyleNode;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.compiler.units.requests.IABCBytesRequestResult;
import org.apache.flex.compiler.units.requests.IFileScopeRequestResult;
import org.apache.flex.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.flex.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.flex.compiler.units.requests.ISyntaxTreeRequestResult;

public class MXMLCompilationUnit
extends CompilationUnitBase {
    private final String qname;

    public MXMLCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, int order, String qname) {
        super(project, path, basePriority, qname);
        this.qname = qname;
        ((DefinitionPriority)this.getDefinitionPriority()).setOrder(order);
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.MXML_UNIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        IFileScopeRequestResult fileScopeRequestResult = this.getFileScopeRequest().get();
        MXMLFileScope fileScope = (MXMLFileScope)fileScopeRequestResult.getScopes()[0];
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        IMXMLData mxmlData = this.getMXMLData();
        final HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
        MXMLTreeBuilder builder = new MXMLTreeBuilder(this, this.getFileSpecificationGetter(), this.qname, mxmlData, fileScope, problems);
        IMXMLFileNode fileNode = builder.build();
        try {
            ClassDefinition mainClassDefinition;
            MXMLDocumentNode documentNode = (MXMLDocumentNode)fileNode.getDocumentNode();
            if (documentNode != null && (mainClassDefinition = fileScope.getMainClassDefinition()) != null) {
                TypeScope mainClassScope = (TypeScope)mainClassDefinition.getContainedScope();
                documentNode.setScope(mainClassScope);
            }
            Function<IMXMLStyleNode, ICSSDocument> parseMXMLStyleNode = new Function<IMXMLStyleNode, ICSSDocument>(){

                public ICSSDocument apply(IMXMLStyleNode mxmlStyleNode) {
                    return mxmlStyleNode.getCSSDocument(problems);
                }
            };
            Collection cssDocumentList = Collections2.transform(fileNode.getStyleNodes(), (Function)parseMXMLStyleNode);
            this.updateStyleCompilationUnitDependencies(fileNode.getCSSCompilationSession(), fileScope, cssDocumentList, problems);
            fileNode.getCSSCompilationSession().cssDocuments.addAll(cssDocumentList);
        }
        catch (Exception e) {
            problems.add(new UnexpectedExceptionProblem(e));
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
        this.getProject().addToASTCache(fileNode);
        return new SyntaxTreeRequestResult(fileNode, (ImmutableSet<String>)ImmutableSet.copyOf(fileScope.getSourceDependencies()), fileNode.getIncludeTreeLastModified(), problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        try {
            IMXMLData mxmlData = this.getMXMLData();
            MXMLScopeBuilder scopeBuilder = new MXMLScopeBuilder(this, this.getFileSpecificationGetter(), mxmlData, this.qname, this.getAbsoluteFilename());
            MXMLFileScope fileScope = scopeBuilder.build();
            ImmutableList<OffsetCue> offsetCueList = scopeBuilder.getIncludeHandler().getOffsetCueList();
            OffsetLookup offsetLookup = new OffsetLookup(offsetCueList);
            fileScope.setOffsetLookup(offsetLookup);
            Collection<ICompilerProblem> problemCollection = scopeBuilder.getProblems();
            IFileSpecification rootFileSpec = this.getRootFileSpecification();
            this.getProject().getWorkspace().addIncludedFilesToCompilationUnit(this, (Collection<String>)fileScope.getSourceDependencies());
            ASFileScopeRequestResult aSFileScopeRequestResult = new ASFileScopeRequestResult(this.getDefinitionPromises(), this.getDefinitionPriority(), problemCollection, fileScope, rootFileSpec);
            return aSFileScopeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        ISyntaxTreeRequestResult syntaxTreeRequestResult = this.getSyntaxTreeRequest().get();
        MXMLFileNode fileNode = (MXMLFileNode)syntaxTreeRequestResult.getAST();
        FlexProject project = this.getProject();
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        try {
            ABCBytesRequestResult result;
            ABCBytesRequestResult aBCBytesRequestResult = result = CodeGeneratorManager.getCodeGenerator().generate(project.getWorkspace().getExecutorService(), project.getUseParallelCodeGeneration(), this.getFilenameNoPath(), fileNode, this.getProject(), this.isInvisible(), this.getEncodedDebugFiles());
            return aBCBytesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        }
    }

    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        IABCBytesRequestResult abc = this.getABCBytesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            SWFTagsRequestResult sWFTagsRequestResult = new SWFTagsRequestResult(abc.getABCBytes(), this.qname, abc.getEmbeds());
            return sWFTagsRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        ISyntaxTreeRequestResult syntaxTreeRequestResult = this.getSyntaxTreeRequest().get();
        MXMLFileNode fileNode = (MXMLFileNode)syntaxTreeRequestResult.getAST();
        this.startParsingImports(fileNode);
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        try {
            this.getABCBytesRequest().get();
            HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
            this.updateEmbedCompilationUnitDependencies(fileNode.getEmbedNodes(), problems);
            this.getABCBytesRequest().get();
            IOutgoingDependenciesRequestResult iOutgoingDependenciesRequestResult = new IOutgoingDependenciesRequestResult(){

                @Override
                public ICompilerProblem[] getProblems() {
                    return IOutgoingDependenciesRequestResult.NO_PROBLEMS;
                }
            };
            return iOutgoingDependenciesRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        }
    }

    private IMXMLData getMXMLData() {
        IMXMLDataManager mxmlDataManager = this.getProject().getWorkspace().getMXMLDataManager();
        IFileSpecification rootFileSpec = this.getRootFileSpecification();
        IMXMLData mxmlData = mxmlDataManager.get(rootFileSpec);
        return mxmlData;
    }

    @Override
    public FlexProject getProject() {
        return (FlexProject)super.getProject();
    }
}

