/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.tree.as;

import antlr.Token;
import org.apache.flex.compiler.internal.tree.as.BlockNode;
import org.apache.flex.compiler.internal.tree.as.CatchNode;
import org.apache.flex.compiler.internal.tree.as.TerminalNode;
import org.apache.flex.compiler.internal.tree.as.TreeNode;
import org.apache.flex.compiler.parsing.IASToken;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.ICatchNode;
import org.apache.flex.compiler.tree.as.IStatementNode;
import org.apache.flex.compiler.tree.as.ITerminalNode;
import org.apache.flex.compiler.tree.as.ITryNode;

public class TryNode
extends TreeNode
implements ITryNode,
IStatementNode {
    private BlockNode contentsBlockNode;

    public TryNode(IASToken keyword) {
        this.startBefore(keyword);
        this.contentsBlockNode = new BlockNode();
        this.contentsBlockNode.startAfter((Token)keyword);
        this.contentsBlockNode.endAfter(keyword);
        this.addChild(this.contentsBlockNode);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.TryID;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
    }

    @Override
    public IASNode getStatementContentsNode() {
        return this.contentsBlockNode;
    }

    @Override
    public int getCatchNodeCount() {
        int n = this.getChildCount();
        if (this.getContentsNode() != null) {
            --n;
        }
        if (this.getFinallyNode() != null) {
            --n;
        }
        return n;
    }

    @Override
    public ICatchNode getCatchNode(int i) {
        if (i < 0 || i >= this.getCatchNodeCount()) {
            return null;
        }
        if (this.getContentsNode() != null) {
            ++i;
        }
        return (ICatchNode)this.getChild(i);
    }

    @Override
    public ITerminalNode getFinallyNode() {
        int childCount = this.getChildCount();
        if (childCount < 1) {
            return null;
        }
        IASNode child = this.getChild(childCount - 1);
        if (child instanceof TerminalNode && ((TerminalNode)child).kind == ITerminalNode.TerminalKind.FINALLY) {
            return (ITerminalNode)child;
        }
        return null;
    }

    public void addCatchClause(CatchNode node) {
        this.addChild(node);
    }

    public void addFinallyBlock(TerminalNode node) {
        this.addChild(node);
    }

    public BlockNode getContentsNode() {
        return this.contentsBlockNode;
    }
}

