/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.embedding;

public enum EmbedMIMEType {
    JPEG("image/jpeg", new String[]{".jpg", ".jpeg"}),
    JPG("image/jpg", new String[]{".jpg", ".jpeg"}),
    PNG("image/png", ".png"),
    GIF("image/gif", ".gif"),
    MP3("audio/mpeg", ".mp3"),
    FLASH("application/x-shockwave-flash", ".swf"),
    TEXT("text/plain", ".txt"),
    PROPERTIES("text/plain", ".properties"),
    XML("text/xml", ".xml"),
    PBJ("application/x-pbj", ".pbj"),
    OCT_STRM("application/octet-stream"),
    SKIN("skin"),
    TTF("application/x-font-truetype", ".ttf"),
    TTC("application/x-font-truetype-collection", ".ttc"),
    OTF("application/x-font-opentype", ".otf"),
    FONT("application/x-font"),
    DFONT("application/x-dfont", ".dfont");

    private final String name;
    private final String[] extensions;

    private EmbedMIMEType(String name) {
        this.name = name;
        this.extensions = new String[0];
    }

    private EmbedMIMEType(String name, String extension) {
        this.name = name;
        this.extensions = new String[]{extension};
    }

    private EmbedMIMEType(String name, String[] extensions) {
        this.name = name;
        this.extensions = extensions;
    }

    public String toString() {
        return this.name;
    }

    public static EmbedMIMEType getMimeTypeFromMimeString(String mimeName) {
        if (mimeName == null || mimeName.isEmpty()) {
            return null;
        }
        String lcMimeName = mimeName.toLowerCase();
        for (EmbedMIMEType mimeType : EmbedMIMEType.values()) {
            if (!mimeType.name.equals(lcMimeName)) continue;
            return mimeType;
        }
        return null;
    }

    public static EmbedMIMEType getMimeTypeFromFilename(String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        String lcFilename = filename.toLowerCase();
        for (EmbedMIMEType mimeType : EmbedMIMEType.values()) {
            for (String extension : mimeType.extensions) {
                int elen;
                int nlen = lcFilename.length();
                if (nlen <= (elen = extension.length()) || !lcFilename.regionMatches(false, nlen - elen, extension, 0, elen)) continue;
                return mimeType;
            }
        }
        return null;
    }
}

