/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.config;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.flex.compiler.config.ConfigurationValue;
import org.apache.flex.compiler.exceptions.ConfigurationException;
import org.apache.flex.compiler.filespecs.IFileSpecification;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LoadExternsParser
extends DefaultHandler {
    private final List<String> externs = new ArrayList<String>();

    public static List<String> collectExterns(ConfigurationValue cfgval, IFileSpecification file) throws ConfigurationException.ConfigurationIOError {
        LoadExternsParser loadExternParser = new LoadExternsParser();
        String filePath = file.getPath();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(filePath, (DefaultHandler)loadExternParser);
        }
        catch (Exception e) {
            throw new ConfigurationException.ConfigurationIOError(filePath, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        return loadExternParser.externs;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String id;
        if (("def".equals(qName) || "pre".equals(qName) || "ext".equals(qName)) && (id = attributes.getValue("id")) != null) {
            this.externs.add(this.fromColonToDotQName(id));
        }
    }

    private String fromColonToDotQName(String qname) {
        StringBuilder sb = new StringBuilder(qname);
        int lastDotIndex = qname.lastIndexOf(58);
        if (lastDotIndex > -1) {
            sb.setCharAt(lastDotIndex, '.');
        }
        return sb.toString();
    }
}

