/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.abc.semantics;

import org.apache.flex.abc.semantics.Namespace;
import org.apache.flex.abc.semantics.Nsset;

public class Name {
    public static final Namespace packageNs = new Namespace(22);
    private static final long PRIME_MULTIPLIER = 8887L;
    private final int kind;
    private final String baseName;
    private final Nsset qualifiers;
    private Name typeNameBase;
    private Name typeNameParameter;
    private Integer cachedHashCode = null;

    public Name(String baseName) {
        this(packageNs, baseName);
    }

    public Name(Namespace ns, String baseName) {
        this(7, new Nsset(ns), baseName, null, null);
    }

    public Name(Nsset multiname_qualifiers, String baseName) {
        this(9, multiname_qualifiers, baseName, null, null);
    }

    public Name(int kind, Nsset qualifiers, String baseName) {
        this(kind, qualifiers, baseName, null, null);
        assert (kind != 29) : "Use the Name(Name, Name) constructor to construct a Name with kind CONSTANT_TypeName";
    }

    public Name(Name typename_base, Name typename_parameter) {
        this(29, null, null, typename_base, typename_parameter);
    }

    private Name(int kind, Nsset qualifiers, String baseName, Name typename_base, Name typename_parameter) {
        this.kind = kind;
        this.baseName = baseName;
        this.qualifiers = qualifiers;
        this.typeNameBase = typename_base;
        this.typeNameParameter = typename_parameter;
    }

    private String getKindString() {
        switch (this.kind) {
            case 7: {
                return "Qname";
            }
            case 13: {
                return "QnameA";
            }
            case 9: {
                return "Multiname";
            }
            case 14: {
                return "MultinameA";
            }
            case 27: {
                return "MultinameL";
            }
            case 28: {
                return "MultinameLA";
            }
            case 29: {
                return "TypeName";
            }
            case 15: {
                return "RTQname";
            }
            case 16: {
                return "RTQnameA";
            }
            case 17: {
                return "RTQnameL";
            }
            case 18: {
                return "RTQnameLA";
            }
        }
        return "<Unknown kind>";
    }

    public boolean isAttributeName() {
        switch (this.kind) {
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getKindString());
        switch (this.kind) {
            case 7: 
            case 9: 
            case 13: 
            case 14: {
                result.append(": ");
                result.append(this.getBaseName());
                result.append("::");
                if (this.qualifiers == null) break;
                result.append(this.qualifiers.toString());
                break;
            }
            case 15: 
            case 16: {
                result.append(": ");
                result.append(this.getBaseName());
                break;
            }
            case 17: 
            case 18: {
                break;
            }
            case 27: 
            case 28: {
                result.append(": ");
                if (this.qualifiers == null) break;
                result.append(this.qualifiers.toString());
                break;
            }
            case 29: {
                result.append(": ");
                result.append(this.typeNameBase.toString());
                result.append(".<");
                if (this.typeNameParameter != null) {
                    result.append(this.typeNameParameter.toString());
                } else {
                    result.append("*");
                }
                result.append(">");
            }
        }
        return result.toString();
    }

    private boolean isEqualTo(Name other) {
        boolean result = true;
        if (this.kind != 29) {
            if (this.qualifiers != other.qualifiers) {
                result = this.qualifiers != null && other.qualifiers != null ? this.qualifiers.equals(other.qualifiers) : false;
            }
            if (result) {
                String this_base = this.getBaseName();
                String other_base = other.getBaseName();
                result = this_base != null && other_base != null ? this_base.equals(other_base) : this_base == null && other_base == null;
            }
        } else {
            result = this.typeNameBase.equals(other.typeNameBase);
            if (result && this.typeNameParameter != null) {
                result = other.typeNameParameter != null ? this.typeNameParameter.equals(other.typeNameParameter) : false;
            }
        }
        return result;
    }

    public Namespace getSingleQualifier() {
        return this.qualifiers != null ? this.qualifiers.getSingleQualifier() : null;
    }

    public int getKind() {
        return this.kind;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Nsset getQualifiers() {
        return this.qualifiers;
    }

    public boolean isTypeName() {
        return this.kind == 29;
    }

    public boolean couldBeAnyType() {
        return !(this.kind != 7 && this.kind != 9 || this.baseName != null && !this.baseName.equals("*"));
    }

    public Name getTypeNameBase() {
        return this.typeNameBase;
    }

    public Name getTypeNameParameter() {
        return this.typeNameParameter;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            int result = this.kind;
            if (this.kind != 29) {
                result = (int)(8887L * (long)result + (long)(this.baseName != null ? this.baseName.hashCode() : 0));
                result = (int)(8887L * (long)result + (long)(this.qualifiers != null ? this.qualifiers.hashCode() : 0));
            } else {
                result = (int)(8887L * (long)result) + this.typeNameBase.hashCode();
                if (this.typeNameParameter != null) {
                    result = (int)(8887L * (long)result) + this.typeNameParameter.hashCode();
                }
            }
            this.cachedHashCode = result;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Name) || this.hashCode() != o.hashCode()) {
            return false;
        }
        return this.isEqualTo((Name)o);
    }

    public void initTypeName(Name base, Name parameter) {
        assert (this.isTypeName()) : "cannot init a Name that is not a type name";
        if (this.typeNameBase == null) {
            this.typeNameBase = base;
        }
        if (this.typeNameParameter == null) {
            this.typeNameParameter = parameter;
        }
        assert (base == this.typeNameBase && parameter == this.typeNameParameter) : "cannot init a typename that has already been initialized";
    }

    public boolean isRuntimeName() {
        switch (this.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public int runtimeNameAllowance() {
        switch (this.kind) {
            case 15: 
            case 27: {
                return 1;
            }
            case 17: {
                return 2;
            }
        }
        return 0;
    }
}

