/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.model.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.parsers.OpenLdapSchemaParser;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.Messages;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileImportException;
import org.eclipse.osgi.util.NLS;

public class OpenLdapSchemaFileImporter {
    public static Schema getSchema(InputStream inputStream, String path) throws OpenLdapSchemaFileImportException {
        OpenLdapSchemaParser parser = new OpenLdapSchemaParser();
        try {
            parser.parse(inputStream);
        }
        catch (IOException e) {
            throw new OpenLdapSchemaFileImportException(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path}), e);
        }
        catch (ParseException | LdapSchemaException e) {
            ExceptionMessage exceptionMessage = OpenLdapSchemaFileImporter.parseExceptionMessage(e.getMessage());
            throw new OpenLdapSchemaFileImportException(String.valueOf(NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.NotReadCorrectly"), (Object[])new String[]{path})) + (exceptionMessage == null ? "" : NLS.bind((String)Messages.getString("OpenLdapSchemaFileImporter.ErrorMessage"), (Object[])new String[]{exceptionMessage.lineNumber, exceptionMessage.columnNumber, exceptionMessage.cause})), (Exception)e);
        }
        String schemaName = OpenLdapSchemaFileImporter.getNameFromPath(path);
        Schema schema = new Schema(schemaName);
        List ats = parser.getAttributeTypes();
        int i = 0;
        while (i < ats.size()) {
            AttributeType at = OpenLdapSchemaFileImporter.convertAttributeType((AttributeType)ats.get(i));
            at.setSchemaName(schemaName);
            schema.addAttributeType(at);
            ++i;
        }
        List ocs = parser.getObjectClasses();
        int i2 = 0;
        while (i2 < ocs.size()) {
            ObjectClass oc = OpenLdapSchemaFileImporter.convertObjectClass((ObjectClass)ocs.get(i2));
            oc.setSchemaName(schemaName);
            schema.addObjectClass(oc);
            ++i2;
        }
        return schema;
    }

    private static String getNameFromPath(String path) {
        File file = new File(path);
        String fileName = file.getName();
        if (fileName.endsWith(".schema")) {
            String[] fileNameSplitted = fileName.split("\\.");
            return fileNameSplitted[0];
        }
        return fileName;
    }

    private static AttributeType convertAttributeType(AttributeType at) {
        AttributeType newAT = new AttributeType(at.getOid());
        newAT.setNames(at.getNames());
        newAT.setDescription(at.getDescription());
        newAT.setSuperiorOid(at.getSuperiorOid());
        newAT.setUsage(at.getUsage());
        newAT.setSyntaxOid(at.getSyntaxOid());
        newAT.setSyntaxLength(at.getSyntaxLength());
        newAT.setObsolete(at.isObsolete());
        newAT.setSingleValued(at.isSingleValued());
        newAT.setCollective(at.isCollective());
        newAT.setUserModifiable(at.isUserModifiable());
        newAT.setEqualityOid(at.getEqualityOid());
        newAT.setOrderingOid(at.getOrderingOid());
        newAT.setSubstringOid(at.getSubstringOid());
        return newAT;
    }

    private static ObjectClass convertObjectClass(ObjectClass oc) {
        ObjectClass newOC = new ObjectClass(oc.getOid());
        newOC.setNames(oc.getNames());
        newOC.setDescription(oc.getDescription());
        newOC.setSuperiorOids(oc.getSuperiorOids());
        newOC.setType(oc.getType());
        newOC.setObsolete(oc.isObsolete());
        newOC.setMustAttributeTypeOids(oc.getMustAttributeTypeOids());
        newOC.setMayAttributeTypeOids(oc.getMayAttributeTypeOids());
        return newOC;
    }

    private static ExceptionMessage parseExceptionMessage(String message) {
        MatchResult result;
        Scanner scanner = new Scanner(new ByteArrayInputStream(message.getBytes()));
        String foundString = scanner.findWithinHorizon(".*line (\\d+):(\\d+): *([^\\n]*).*", message.length());
        if (foundString != null && (result = scanner.match()).groupCount() == 3) {
            ExceptionMessage exceptionMessage = new ExceptionMessage();
            exceptionMessage.lineNumber = result.group(1);
            exceptionMessage.columnNumber = result.group(2);
            exceptionMessage.cause = result.group(3);
            scanner.close();
            return exceptionMessage;
        }
        scanner.close();
        return null;
    }

    private static class ExceptionMessage {
        String lineNumber;
        String columnNumber;
        String cause;

        private ExceptionMessage() {
        }
    }
}

