/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wizards.NewObjectClassWizard;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class NewObjectClassAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TreeViewer viewer;

    public NewObjectClassAction(TreeViewer viewer) {
        super(Messages.getString("NewObjectClassAction.NewObjectClassAction"));
        this.setToolTipText(Messages.getString("NewObjectClassAction.NewObjectClassToolTip"));
        this.setId(PluginConstants.CMD_NEW_OBJECT_CLASS);
        this.setActionDefinitionId(PluginConstants.CMD_NEW_OBJECT_CLASS);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/object_class_new.gif"));
        this.setEnabled(false);
        this.viewer = viewer;
    }

    public void run() {
        StructuredSelection selection;
        Schema selectedSchema = null;
        int presentation = Activator.getDefault().getPreferenceStore().getInt(PluginConstants.PREFS_SCHEMA_VIEW_SCHEMA_PRESENTATION);
        if (presentation == 0 && !(selection = (StructuredSelection)this.viewer.getSelection()).isEmpty() && selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof SchemaWrapper) {
                selectedSchema = ((SchemaWrapper)firstElement).getSchema();
            } else if (firstElement instanceof Folder) {
                selectedSchema = ((SchemaWrapper)((Folder)firstElement).getParent()).getSchema();
            } else if (firstElement instanceof AttributeTypeWrapper) {
                TreeNode parent = ((AttributeTypeWrapper)firstElement).getParent();
                if (parent instanceof Folder) {
                    selectedSchema = ((SchemaWrapper)((Folder)parent).getParent()).getSchema();
                } else if (parent instanceof SchemaWrapper) {
                    selectedSchema = ((SchemaWrapper)parent).getSchema();
                }
            } else if (firstElement instanceof ObjectClassWrapper) {
                TreeNode parent = ((ObjectClassWrapper)firstElement).getParent();
                if (parent instanceof Folder) {
                    selectedSchema = ((SchemaWrapper)((Folder)parent).getParent()).getSchema();
                } else if (parent instanceof SchemaWrapper) {
                    selectedSchema = ((SchemaWrapper)parent).getSchema();
                }
            }
        }
        NewObjectClassWizard wizard = new NewObjectClassWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        wizard.setSelectedSchema(selectedSchema);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

