/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.Messages;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.controller.actions.CloseProjectAction;
import org.apache.directory.studio.schemaeditor.controller.actions.DeleteProjectAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ExportProjectsAction;
import org.apache.directory.studio.schemaeditor.controller.actions.ImportProjectsAction;
import org.apache.directory.studio.schemaeditor.controller.actions.NewProjectAction;
import org.apache.directory.studio.schemaeditor.controller.actions.OpenProjectAction;
import org.apache.directory.studio.schemaeditor.controller.actions.RenameProjectAction;
import org.apache.directory.studio.schemaeditor.model.Project;
import org.apache.directory.studio.schemaeditor.view.views.ProjectsView;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ProjectsViewRoot;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class ProjectsViewController {
    private ProjectsView view;
    private MenuManager contextMenu;
    private TableViewer viewer;
    private ProjectsHandler projectsHandler;
    private IContextActivation contextActivation;
    private NewProjectAction newProject;
    private OpenProjectAction openProject;
    private CloseProjectAction closeProject;
    private RenameProjectAction renameProject;
    private DeleteProjectAction deleteProject;
    private ImportProjectsAction importProjects;
    private ExportProjectsAction exportProjects;

    public ProjectsViewController(ProjectsView view) {
        this.view = view;
        this.viewer = view.getViewer();
        this.projectsHandler = Activator.getDefault().getProjectsHandler();
        this.initActions();
        this.initToolbar();
        this.initContextMenu();
        this.initViewer();
        this.initDoubleClickListener();
        this.initPartListener();
    }

    private void initActions() {
        this.newProject = new NewProjectAction();
        this.openProject = new OpenProjectAction(this.view.getViewer());
        this.closeProject = new CloseProjectAction(this.view.getViewer());
        this.renameProject = new RenameProjectAction(this.view.getViewer());
        this.deleteProject = new DeleteProjectAction(this.view.getViewer());
        this.importProjects = new ImportProjectsAction();
        this.exportProjects = new ExportProjectsAction(this.view.getViewer());
    }

    private void initToolbar() {
        IToolBarManager toolbar = this.view.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.newProject);
    }

    private void initContextMenu() {
        this.contextMenu = new MenuManager("");
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MenuManager importManager = new MenuManager(Messages.getString("ProjectsViewController.ImportAction"));
                MenuManager exportManager = new MenuManager(Messages.getString("ProjectsViewController.ExportAction"));
                manager.add((IAction)ProjectsViewController.this.newProject);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ProjectsViewController.this.openProject);
                manager.add((IAction)ProjectsViewController.this.closeProject);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ProjectsViewController.this.renameProject);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)ProjectsViewController.this.deleteProject);
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)importManager);
                importManager.add((IAction)ProjectsViewController.this.importProjects);
                manager.add((IContributionItem)exportManager);
                exportManager.add((IAction)ProjectsViewController.this.exportProjects);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.viewer.getControl().setMenu(this.contextMenu.createContextMenu(this.viewer.getControl()));
        this.view.getSite().registerContextMenu(this.contextMenu, (ISelectionProvider)this.viewer);
    }

    private void initViewer() {
        this.viewer.setInput((Object)new ProjectsViewRoot(this.viewer));
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == Action.findKeyCode((String)"BACKSPACE") || e.keyCode == Action.findKeyCode((String)"DELETE")) {
                    ProjectsViewController.this.deleteProject.run();
                }
            }
        });
    }

    private void initDoubleClickListener() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Project project;
                StructuredSelection selection = (StructuredSelection)ProjectsViewController.this.viewer.getSelection();
                if (!selection.isEmpty() && selection.size() == 1 && (project = ((ProjectWrapper)selection.getFirstElement()).getProject()).getState().equals((Object)Project.ProjectState.CLOSED)) {
                    ProjectsViewController.this.projectsHandler.openProject(project);
                }
            }
        });
    }

    private void initPartListener() {
        this.view.getSite().getPage().addPartListener(new IPartListener2(){

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ProjectsViewController.this.view && ProjectsViewController.this.contextActivation != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                    if (commandService != null) {
                        commandService.getCommand(ProjectsViewController.this.newProject.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ProjectsViewController.this.renameProject.getActionDefinitionId()).setHandler(null);
                        commandService.getCommand(ProjectsViewController.this.deleteProject.getActionDefinitionId()).setHandler(null);
                    }
                    IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                    contextService.deactivateContext(ProjectsViewController.this.contextActivation);
                    ProjectsViewController.this.contextActivation = null;
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ProjectsViewController.this.view) {
                    IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
                    ProjectsViewController.this.contextActivation = contextService.activateContext(PluginConstants.CONTEXT_PROJECTS_VIEW);
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
                    if (commandService != null) {
                        commandService.getCommand(ProjectsViewController.this.newProject.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ProjectsViewController.this.newProject));
                        commandService.getCommand(ProjectsViewController.this.renameProject.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ProjectsViewController.this.renameProject));
                        commandService.getCommand(ProjectsViewController.this.deleteProject.getActionDefinitionId()).setHandler((IHandler)new ActionHandler((IAction)ProjectsViewController.this.deleteProject));
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        });
    }
}

