/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.Messages;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaCheckerListener;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditorInput;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.directory.studio.schemaeditor.view.views.ProblemsView;
import org.apache.directory.studio.schemaeditor.view.widget.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaErrorWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWarningWrapper;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ProblemsViewController {
    private ProblemsView view;
    private SchemaCheckerListener schemaCheckerListener = new SchemaCheckerListener(){

        @Override
        public void schemaCheckerUpdated() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProblemsViewController.this.view.reloadViewer();
                }
            });
        }
    };

    public ProblemsViewController(ProblemsView view) {
        this.view = view;
        Activator.getDefault().getSchemaChecker().addListener(this.schemaCheckerListener);
        this.initDoubleClickListener();
    }

    private void initDoubleClickListener() {
        this.view.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SchemaObject object;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                TreeViewer viewer = ProblemsViewController.this.view.getViewer();
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object objectSelection = selection.getFirstElement();
                Object input = null;
                String editorId = null;
                if (objectSelection instanceof SchemaErrorWrapper) {
                    object = ((SchemaErrorWrapper)objectSelection).getLdapSchemaException().getSourceObject();
                    if (object instanceof AttributeType) {
                        input = new AttributeTypeEditorInput(Activator.getDefault().getSchemaHandler().getAttributeType(object.getOid()));
                        editorId = AttributeTypeEditor.ID;
                    } else if (object instanceof ObjectClass) {
                        input = new ObjectClassEditorInput(Activator.getDefault().getSchemaHandler().getObjectClass(object.getOid()));
                        editorId = ObjectClassEditor.ID;
                    }
                } else if (objectSelection instanceof SchemaWarningWrapper) {
                    object = ((SchemaWarningWrapper)objectSelection).getSchemaWarning().getSource();
                    if (object instanceof AttributeType) {
                        input = new AttributeTypeEditorInput((AttributeType)object);
                        editorId = AttributeTypeEditor.ID;
                    } else if (object instanceof ObjectClass) {
                        input = new ObjectClassEditorInput((ObjectClass)object);
                        editorId = ObjectClassEditor.ID;
                    }
                } else if (objectSelection instanceof Folder) {
                    viewer.setExpandedState(objectSelection, !viewer.getExpandedState(objectSelection));
                }
                if (input != null) {
                    try {
                        page.openEditor(input, editorId);
                    }
                    catch (PartInitException e) {
                        PluginUtils.logError(Messages.getString("ProblemsViewController.ErrorOpeningEditor"), e);
                        ViewUtils.displayErrorMessageDialog(Messages.getString("ProblemsViewController.Error"), Messages.getString("ProblemsViewController.ErrorOpeningEditor"));
                    }
                }
            }
        });
    }

    public void dispose() {
        Activator.getDefault().getSchemaChecker().removeListener(this.schemaCheckerListener);
    }
}

