/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.studio.ldifparser.LdifParserConstants;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;

public class LdifModSpecTypeLine
extends LdifValueLineBase {
    public LdifModSpecTypeLine(int offset, String rawModType, String rawValueType, String rawAttributeDescription, String rawNewLine) {
        super(offset, rawModType, rawValueType, rawAttributeDescription, rawNewLine);
    }

    public String getRawModType() {
        return super.getRawLineStart();
    }

    public String getUnfoldedModType() {
        return super.getUnfoldedLineStart();
    }

    public String getRawAttributeDescription() {
        return super.getRawValue();
    }

    public String getUnfoldedAttributeDescription() {
        return super.getUnfoldedValue();
    }

    public boolean isAdd() {
        return this.getUnfoldedModType().equals("add");
    }

    public boolean isReplace() {
        return this.getUnfoldedModType().equals("replace");
    }

    public boolean isDelete() {
        return this.getUnfoldedModType().equals("delete");
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (this.isAdd() || this.isReplace() || this.isDelete());
    }

    @Override
    public String getInvalidString() {
        if (this.getUnfoldedModType().length() == 0) {
            return "Missing modification type 'add', 'replace' or 'delete'";
        }
        if (!(this.isAdd() || this.isReplace() || this.isDelete())) {
            return "Invalid modification type, expected 'add', 'replace' or 'delete'";
        }
        if (this.getUnfoldedAttributeDescription().length() == 0) {
            return "Missing attribute";
        }
        return super.getInvalidString();
    }

    public static LdifModSpecTypeLine createAdd(String attributeName) {
        return new LdifModSpecTypeLine(0, "add", ":", attributeName, LdifParserConstants.LINE_SEPARATOR);
    }

    public static LdifModSpecTypeLine createReplace(String attributeName) {
        return new LdifModSpecTypeLine(0, "replace", ":", attributeName, LdifParserConstants.LINE_SEPARATOR);
    }

    public static LdifModSpecTypeLine createDelete(String attributeName) {
        return new LdifModSpecTypeLine(0, "delete", ":", attributeName, LdifParserConstants.LINE_SEPARATOR);
    }
}

