/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.lines;

import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.LdifPart;

public abstract class LdifLineBase
implements LdifPart {
    protected int offset;
    protected String rawNewLine;

    protected LdifLineBase() {
    }

    protected LdifLineBase(int offset, String rawNewLine) {
        this.offset = offset;
        this.rawNewLine = rawNewLine;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    public final String getRawNewLine() {
        return LdifLineBase.getNonNull(this.rawNewLine);
    }

    public String getUnfoldedNewLine() {
        return LdifLineBase.unfold(this.getRawNewLine());
    }

    @Override
    public final void adjustOffset(int adjust) {
        this.offset += adjust;
    }

    @Override
    public final int getLength() {
        return this.toRawString().length();
    }

    @Override
    public boolean isValid() {
        return this.rawNewLine != null;
    }

    @Override
    public String getInvalidString() {
        if (this.rawNewLine == null) {
            return "Missing new line";
        }
        return null;
    }

    @Override
    public String toRawString() {
        return this.getRawNewLine();
    }

    @Override
    public String toFormattedString(LdifFormatParameters formatParameters) {
        int index;
        String raw = this.toRawString();
        String unfolded = LdifLineBase.unfold(raw);
        if (this.rawNewLine != null && (index = unfolded.lastIndexOf(this.rawNewLine)) > -1) {
            unfolded = unfolded.substring(0, unfolded.length() - this.rawNewLine.length());
            unfolded = String.valueOf(unfolded) + formatParameters.getLineSeparator();
        }
        return unfolded;
    }

    public final String toString() {
        String text = this.toRawString();
        text = LdifUtils.convertNlRcToString(text);
        return String.valueOf(this.getClass().getName()) + " (" + this.getOffset() + "," + this.getLength() + "): '" + text + "'";
    }

    protected static String getNonNull(String s) {
        return s != null ? s : "";
    }

    protected static String unfold(String s) {
        char[] newString = s.toCharArray();
        int pos = 0;
        int length = newString.length;
        int i = 0;
        while (i < length) {
            char c = newString[i];
            if (c == '\n') {
                if (i + 1 < length) {
                    switch (newString[i + 1]) {
                        case ' ': {
                            ++i;
                            break;
                        }
                        case '\r': {
                            if (i + 2 < length && newString[i + 2] == ' ') {
                                i += 2;
                                break;
                            }
                            newString[pos++] = c;
                            newString[pos++] = 13;
                            ++i;
                            break;
                        }
                        default: {
                            newString[pos++] = c;
                            break;
                        }
                    }
                } else {
                    newString[pos++] = c;
                }
            } else if (c == '\r') {
                if (i + 1 < length) {
                    switch (newString[i + 1]) {
                        case ' ': {
                            ++i;
                            break;
                        }
                        case '\n': {
                            if (i + 2 < length && newString[i + 2] == ' ') {
                                i += 2;
                                break;
                            }
                            newString[pos++] = c;
                            newString[pos++] = 10;
                            ++i;
                            break;
                        }
                        default: {
                            newString[pos++] = c;
                            break;
                        }
                    }
                } else {
                    newString[pos++] = c;
                }
            } else {
                newString[pos++] = c;
            }
            ++i;
        }
        return new String(newString, 0, pos);
    }

    protected static String fold(String value, int indent, LdifFormatParameters formatParameters) {
        StringBuffer formattedLdif = new StringBuffer();
        int offset = formatParameters.getLineWidth() - indent;
        int endIndex = 0 + offset;
        while (endIndex + formatParameters.getLineSeparator().length() < value.length()) {
            formattedLdif.append(value.substring(endIndex - offset, endIndex));
            formattedLdif.append(formatParameters.getLineSeparator());
            formattedLdif.append(' ');
            offset = formatParameters.getLineWidth() - 1;
            endIndex += offset;
        }
        String rest = value.substring(endIndex - offset, value.length());
        formattedLdif.append(rest);
        return formattedLdif.toString();
    }
}

