/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.io.ConnectionIO;
import org.apache.directory.studio.ldapbrowser.core.BrowserConnectionIO;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportBaseWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.ExportConnectionsWizardPage;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class ExportConnectionsWizard
extends ExportBaseWizard {
    private ExportConnectionsWizardPage page;

    public ExportConnectionsWizard() {
        super(Messages.getString("ExportConnectionsWizard.ConnectionsExport"));
    }

    public static String getId() {
        return "org.apache.directory.studio.ldapbrowser.ui.wizards.ImportConnectionsWizard";
    }

    public void addPages() {
        this.page = new ExportConnectionsWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean performFinish() {
        this.page.saveDialogSettings();
        String exportFileName = this.page.getExportFileName();
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(exportFileName)));
            zos.putNextEntry(new ZipEntry("connections.xml"));
            Connection[] connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections();
            HashSet<ConnectionParameter> connectionParameters = new HashSet<ConnectionParameter>();
            Connection[] connectionArray = connections;
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                Connection connection = connectionArray[n2];
                connectionParameters.add(connection.getConnectionParameter());
                ++n2;
            }
            ConnectionIO.save(connectionParameters, (OutputStream)zos);
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("connectionFolders.xml"));
            ConnectionFolder[] connectionFolders = ConnectionCorePlugin.getDefault().getConnectionFolderManager().getConnectionFolders();
            HashSet<ConnectionFolder> connectionFoldersSet = new HashSet<ConnectionFolder>();
            ConnectionFolder[] connectionFolderArray = connectionFolders;
            int n3 = connectionFolders.length;
            int n4 = 0;
            while (n4 < n3) {
                ConnectionFolder connectionFolder = connectionFolderArray[n4];
                connectionFoldersSet.add(connectionFolder);
                ++n4;
            }
            ConnectionIO.saveConnectionFolders(connectionFoldersSet, (OutputStream)zos);
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("browserconnections.xml"));
            IBrowserConnection[] browserConnections = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnections();
            HashMap<String, IBrowserConnection> browserConnectionsMap = new HashMap<String, IBrowserConnection>();
            IBrowserConnection[] iBrowserConnectionArray = browserConnections;
            int n5 = browserConnections.length;
            int n6 = 0;
            while (n6 < n5) {
                IBrowserConnection browserConnection = iBrowserConnectionArray[n6];
                browserConnectionsMap.put(browserConnection.getConnection().getId(), browserConnection);
                ++n6;
            }
            BrowserConnectionIO.save((OutputStream)zos, browserConnectionsMap);
            zos.closeEntry();
            zos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

