/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import org.apache.directory.server.dns.util.EnumConverter;
import org.apache.directory.server.dns.util.ReverseEnumMap;

public enum ProtocolType implements EnumConverter<Byte>
{
    NULL(0),
    ICMP(1),
    IGMP(2),
    GGP(3),
    ST(5),
    TCP(6),
    UCL(7),
    EGP(8),
    IGP(9),
    BBN_RCC_MON(10),
    NVP_II(11),
    PUP(12),
    ARGUS(13),
    EMCON(14),
    XNET(15),
    CHAOS(16),
    UDP(17),
    MUX(18),
    DCN_MEAS(19),
    HMP(20),
    PRM(21),
    XNS_IDP(22),
    TRUNK_1(23),
    TRUNK_2(24),
    LEAF_1(25),
    LEAF_2(26),
    RDP(27),
    IRTP(28),
    ISO_TP4(29),
    NETBLT(30),
    MFE_NSP(31),
    MERIT_INP(32),
    SEP(33),
    CFTP(62),
    SAT_EXPAK(64),
    MIT_SUBNET(65),
    RVD(66),
    IPPC(67),
    SAT_MON(69),
    IPCV(71),
    BR_SAT_MON(76),
    WB_MON(78),
    WB_EXPAK(79);

    private static ReverseEnumMap<Byte, ProtocolType> map;
    private final byte value;

    private ProtocolType(int value) {
        this.value = (byte)value;
    }

    @Override
    public Byte convert() {
        return this.value;
    }

    public static ProtocolType convert(byte value) {
        return map.get(value);
    }

    static {
        map = new ReverseEnumMap(ProtocolType.class);
    }
}

