/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.KeyCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;

class ValueBTreeCursor<V>
implements ValueCursor<V> {
    private KeyCursor<V> cursor;
    private BTree<V, V> valueBtree;

    public ValueBTreeCursor(BTree<V, V> valueBtree) {
        this.valueBtree = valueBtree;
        try {
            if (valueBtree != null) {
                this.cursor = valueBtree.browseKeys();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KeyNotFoundException knfe) {
            knfe.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.cursor == null) {
            return false;
        }
        try {
            return this.cursor.hasNext();
        }
        catch (EndOfFileExceededException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public V next() {
        try {
            return this.cursor.next();
        }
        catch (EndOfFileExceededException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasPrev() throws EndOfFileExceededException, IOException {
        if (this.cursor == null) {
            return false;
        }
        try {
            return this.cursor.hasPrev();
        }
        catch (EndOfFileExceededException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Override
    public void beforeFirst() throws IOException {
        if (this.cursor != null) {
            this.cursor.beforeFirst();
        }
    }

    @Override
    public void afterLast() throws IOException {
        if (this.cursor != null) {
            this.cursor.afterLast();
        }
    }

    @Override
    public V prev() throws EndOfFileExceededException, IOException {
        try {
            return this.cursor.prev();
        }
        catch (EndOfFileExceededException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int size() {
        return (int)this.valueBtree.getNbElems();
    }

    public String toString() {
        return "BTreeCursor";
    }
}

