/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.directory.mavibot.btree;


import static org.junit.Assert.assertEquals;

import org.junit.Test;


/**
 * Test the RevisionNameComparator class
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class RevisionNameComparatorTest
{
    @Test
    public void testRevisionNameComparator()
    {
        RevisionNameComparator comparator = RevisionNameComparator.INSTANCE;

        assertEquals( 0, comparator.compare( null, null ) );
        assertEquals( 0, comparator.compare( new RevisionName( 0L, "test" ), new RevisionName( 0L, "test" ) ) );
        assertEquals( 1, comparator.compare( new RevisionName( 3L, "test" ), new RevisionName( 0L, "test" ) ) );
        assertEquals( -1, comparator.compare( new RevisionName( 3L, "test" ), new RevisionName( 5L, "test" ) ) );
        assertEquals( 1, comparator.compare( new RevisionName( 3L, "test2" ), new RevisionName( 3L, "test1" ) ) );
        assertEquals( -1, comparator.compare( new RevisionName( 3L, "test" ), new RevisionName( 3L, "test2" ) ) );
    }
}
