/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.model.Mod;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.panel.AuditModDetailPanel;
import org.apache.directory.fortress.web.panel.Displayable;
import org.apache.directory.fortress.web.panel.RequestMod;
import org.apache.directory.fortress.web.panel.UserAuditDetailPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditModDetailPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    public static final int MOD_OFFSET = 3;
    public static final int ROWS = 5;
    @SpringBean
    private AuditMgr auditMgr;
    @SpringBean
    private ReviewMgr reviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditModDetailPanel.class.getName());
    private Form detailForm;
    private Displayable display;
    private UserAuditDetailPanel userPanel;

    public Form getForm() {
        return this.detailForm;
    }

    public AuditModDetailPanel(String id, Displayable display) {
        super(id);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.auditMgr.setAdmin(SecUtils.getSession((Component)this));
            this.reviewMgr.setAdmin(SecUtils.getSession((Component)this));
        }
        this.detailForm = new AuditAuthzDetailForm(this, "detailFields", (IModel)new CompoundPropertyModel((Object)new Mod()));
        this.display = display;
        this.add(new Component[]{this.detailForm});
    }

    private IDataProvider<RequestMod> createDataProvider(List<RequestMod> mods) {
        ListDataProvider results = CollectionUtils.isNotEmpty(mods) ? new ListDataProvider(mods) : new ListDataProvider(new ArrayList());
        return results;
    }
}

