/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.PropertyMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.PropertyMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.PropertyMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public class PropertyMgrFactory {
    private static final String CLS_NM = PropertyMgrFactory.class.getName();

    public static PropertyMgr createInstance() throws SecurityException {
        return PropertyMgrFactory.createInstance("HOME");
    }

    public static PropertyMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String propertyClassName = Config.getInstance().getProperty("propertymgr.implementation");
        PropertyMgr propertyMgr = StringUtils.isEmpty((String)propertyClassName) ? (Config.getInstance().isRestEnabled() ? new PropertyMgrRestImpl() : new PropertyMgrImpl()) : (PropertyMgr)ClassUtil.createInstance(propertyClassName);
        propertyMgr.setContextId(contextId);
        return propertyMgr;
    }

    public static PropertyMgr createInstance(Session adminSess) throws SecurityException {
        return PropertyMgrFactory.createInstance("HOME", adminSess);
    }

    public static PropertyMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        PropertyMgr propertyMgr = PropertyMgrFactory.createInstance(contextId);
        propertyMgr.setAdmin(adminSess);
        return propertyMgr;
    }
}

