/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.Set;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.impl.avl.AvlPartition;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.impl.avl.AvlIndex;

public class AvlPartitionFactory
implements PartitionFactory {
    @Override
    public AvlPartition createPartition(SchemaManager schemaManager, DnFactory dnFactory, String id, String suffix, int cacheSize, File workingDirectory) throws Exception {
        AvlPartition partition = new AvlPartition(schemaManager, dnFactory);
        partition.setId(id);
        partition.setSuffixDn(new Dn(suffix));
        partition.setCacheSize(500);
        partition.setPartitionPath(workingDirectory.toURI());
        return partition;
    }

    @Override
    public void addIndex(Partition partition, String attributeId, int cacheSize) throws Exception {
        if (!(partition instanceof AvlPartition)) {
            throw new IllegalArgumentException("Partition must be a AvlPartition");
        }
        AvlPartition avlPartition = (AvlPartition)partition;
        Set<Index<?, String>> indexedAttributes = avlPartition.getIndexedAttributes();
        AvlIndex index = new AvlIndex(attributeId, false);
        indexedAttributes.add(index);
        avlPartition.setIndexedAttributes(indexedAttributes);
    }
}

