/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.TreeSet;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class ModelPropertyPointer
extends PropertyPointer {
    private static final long serialVersionUID = 1L;
    private static final Object UNINITIALIZED = new Object();
    private String name;
    private final JXPathBeanInfo beanInfo;
    private final Class<?> valueClass;
    private Object baseValue = UNINITIALIZED;
    private Object value = UNINITIALIZED;
    private transient String[] propertyNames;
    private transient PropertyDescriptor[] propertyDescriptors;
    private transient PropertyDescriptor propertyDescriptor;
    private transient Field field;

    public ModelPropertyPointer(NodePointer parent, JXPathBeanInfo beanInfo, Class<?> valueClass) {
        super(parent);
        this.beanInfo = beanInfo;
        this.valueClass = valueClass;
    }

    public boolean isContainer() {
        return true;
    }

    public int getPropertyCount() {
        if (this.beanInfo.isAtomic()) {
            return 0;
        }
        return this.getPropertyNames().length;
    }

    public String[] getPropertyNames() {
        if (this.propertyNames == null) {
            TreeSet<String> names = new TreeSet<String>();
            for (PropertyDescriptor pd : this.beanInfo.getPropertyDescriptors()) {
                names.add(pd.getName());
            }
            for (Field f : this.valueClass.getFields()) {
                if (!Modifier.isPublic(f.getModifiers())) continue;
                names.add(f.getName());
            }
            this.propertyNames = names.toArray(new String[0]);
        }
        return this.propertyNames;
    }

    public void setPropertyName(String name) {
        this.setPropertyIndex(Integer.MIN_VALUE);
        this.name = name;
    }

    public void setPropertyIndex(int index) {
        if (this.propertyIndex != index) {
            super.setPropertyIndex(index);
            this.name = null;
            this.propertyDescriptor = null;
            this.field = null;
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
    }

    public Object getBaseValue() {
        if (this.baseValue == UNINITIALIZED) {
            PropertyDescriptor pd = this.getPropertyDescriptor();
            if (pd == null) {
                Field f = this.getField();
                if (f == null) {
                    return null;
                }
                this.baseValue = this.getFieldValue(f);
            } else {
                this.baseValue = ValueUtils.getValue((Object)this.getBean(), (PropertyDescriptor)pd);
            }
        }
        return this.baseValue;
    }

    public void setIndex(int index) {
        if (this.index == index) {
            return;
        }
        if (this.index != Integer.MIN_VALUE || index != 0 || this.isCollection()) {
            super.setIndex(index);
            this.value = UNINITIALIZED;
        }
    }

    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            Field f;
            PropertyDescriptor pd;
            this.value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue((Object)this.getBaseValue()) : ((pd = this.getPropertyDescriptor()) == null ? ((f = this.getField()) == null ? null : ValueUtils.getValue((Object)this.getFieldValue(f), (int)this.index)) : ValueUtils.getValue((Object)this.getBean(), (PropertyDescriptor)pd, (int)this.index));
        }
        return this.value;
    }

    protected boolean isActualProperty() {
        return this.getPropertyDescriptor() != null || this.getField() != null;
    }

    public boolean isCollection() {
        int hint;
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            Field f = this.getField();
            if (f == null) {
                return false;
            }
            hint = ValueUtils.getCollectionHint(this.field.getType());
        } else {
            if (pd instanceof IndexedPropertyDescriptor) {
                return true;
            }
            hint = ValueUtils.getCollectionHint(pd.getPropertyType());
        }
        if (hint == -1) {
            return false;
        }
        if (hint == 1) {
            return true;
        }
        Object v = this.getBaseValue();
        return v != null && ValueUtils.isCollection((Object)v);
    }

    public int getLength() {
        int hint;
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            Field f = this.getField();
            if (f == null) {
                return 1;
            }
            hint = ValueUtils.getCollectionHint(f.getType());
        } else {
            if (pd instanceof IndexedPropertyDescriptor) {
                return ValueUtils.getIndexedPropertyLength((Object)this.getBean(), (IndexedPropertyDescriptor)((IndexedPropertyDescriptor)pd));
            }
            hint = ValueUtils.getCollectionHint(pd.getPropertyType());
        }
        if (hint == -1) {
            return 1;
        }
        return ValueUtils.getLength((Object)this.getBaseValue());
    }

    public void setValue(Object value) {
        PropertyDescriptor pd = this.getPropertyDescriptor();
        if (pd == null) {
            Field f = this.getField();
            if (f == null) {
                throw new JXPathInvalidAccessException("Cannot set property: " + this.asPath() + " - no such property");
            }
            this.setFieldValue(f, value);
        } else if (this.index == Integer.MIN_VALUE) {
            ValueUtils.setValue((Object)this.getBean(), (PropertyDescriptor)pd, (Object)value);
        } else {
            ValueUtils.setValue((Object)this.getBean(), (PropertyDescriptor)pd, (int)this.index, (Object)value);
        }
        this.value = value;
    }

    public NodePointer createPath(JXPathContext context) {
        if (this.getImmediateNode() == null) {
            super.createPath(context);
            this.baseValue = UNINITIALIZED;
            this.value = UNINITIALIZED;
        }
        return this;
    }

    public void remove() {
        if (this.index == Integer.MIN_VALUE) {
            this.setValue(null);
        } else if (this.isCollection()) {
            Object o = this.getBaseValue();
            Object collection = ValueUtils.remove((Object)this.getBaseValue(), (int)this.index);
            if (collection != o) {
                PropertyDescriptor pd = this.getPropertyDescriptor();
                if (pd == null) {
                    Field f = this.getField();
                    this.setFieldValue(f, collection);
                } else {
                    ValueUtils.setValue((Object)this.getBean(), (PropertyDescriptor)this.getPropertyDescriptor(), (Object)collection);
                }
            }
        } else if (this.index == 0) {
            this.index = Integer.MIN_VALUE;
            this.setValue(null);
        }
    }

    public String getPropertyName() {
        if (this.name == null) {
            PropertyDescriptor pd = this.getPropertyDescriptor();
            if (pd != null) {
                this.name = pd.getName();
            } else {
                Field f = this.getField();
                if (f != null) {
                    this.name = f.getName();
                }
            }
        }
        return this.name != null ? this.name : "*";
    }

    private PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            int inx = this.getPropertyIndex();
            if (inx == Integer.MIN_VALUE) {
                this.propertyDescriptor = this.beanInfo.getPropertyDescriptor(this.name);
            } else {
                String[] names = this.getPropertyNames();
                this.propertyDescriptor = inx >= 0 && inx < names.length ? this.beanInfo.getPropertyDescriptor(names[inx]) : null;
            }
        }
        return this.propertyDescriptor;
    }

    private Field getField() {
        if (this.field == null) {
            int inx = this.getPropertyIndex();
            if (inx == Integer.MIN_VALUE) {
                this.field = this.getField(this.name);
            } else {
                String[] names = this.getPropertyNames();
                this.field = inx >= 0 && inx < names.length ? this.getField(names[inx]) : null;
            }
        }
        return this.field;
    }

    private Field getField(String name) {
        try {
            return this.valueClass.getField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new JXPathException("Cannot access property: " + this.valueClass.getName() + "." + name, (Throwable)e);
        }
    }

    private Object getFieldValue(Field field) {
        try {
            return field.get(this.getBean());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JXPathException("Cannot access property: " + (this.bean == null ? "null" : this.bean.getClass().getName()) + "." + this.name, (Throwable)e);
        }
    }

    private void setFieldValue(Field field, Object value) {
        try {
            field.set(this.getBean(), value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JXPathInvalidAccessException("Cannot set property: " + this.asPath(), (Throwable)e);
        }
    }

    protected synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = this.beanInfo.getPropertyDescriptors();
        }
        return this.propertyDescriptors;
    }
}

