/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control.action;

import java.util.Iterator;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.TokenReplacer;
import org.apache.torque.generator.control.action.MergepointAction;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.source.SourcePathPointer;

public class ApplyAction
implements MergepointAction {
    private String path;
    private final String outletName;
    private boolean acceptNotSet = true;

    public ApplyAction(String path, String outletName, Boolean acceptNotSet) {
        this.path = path == null ? "." : path;
        if (outletName == null) {
            throw new IllegalArgumentException("ApplyAction: outletName must not be null");
        }
        this.outletName = outletName;
        if (acceptNotSet != null) {
            this.acceptNotSet = acceptNotSet;
        }
    }

    @Override
    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        TokenReplacer tokenReplacer = new TokenReplacer(controllerState);
        String detokenizedOutletName = tokenReplacer.process(this.outletName);
        QualifiedName qualifiedOutletName = new QualifiedName(detokenizedOutletName, Namespace.ROOT_NAMESPACE);
        Outlet outlet = controllerState.getUnitConfiguration().getOutletConfiguration().getOutlet(qualifiedOutletName);
        if (outlet == null) {
            throw new GeneratorException("ApplyAction : The outlet " + this.outletName + " does not exist");
        }
        Object model = controllerState.getModel();
        String pathToModel = controllerState.getPathToModel();
        String detokenizedPath = tokenReplacer.process(this.path);
        Iterator<SourcePathPointer> selectedObjectsIt = SourcePath.iteratePointer(controllerState.getModelRoot(), pathToModel, model, detokenizedPath);
        if (!selectedObjectsIt.hasNext()) {
            if (!this.acceptNotSet) {
                throw new GeneratorException("ApplyAction : selected path " + this.path + " does not match an element and acceptNotSet was set to false");
            }
            return new OutletResult("");
        }
        SourcePathPointer pointer = selectedObjectsIt.next();
        Object selectedObject = pointer.getValue();
        if (selectedObjectsIt.hasNext()) {
            throw new GeneratorException("ApplyAction : selected path " + this.path + " contains more than one element");
        }
        String oldPathToModel = controllerState.getPathToModel();
        controllerState.setModel(selectedObject, pointer.getPath());
        outlet.beforeExecute(controllerState);
        OutletResult result = outlet.execute(controllerState);
        outlet.afterExecute(controllerState);
        controllerState.setModel(model, null);
        controllerState.setPathToModel(oldPathToModel);
        return result;
    }

    public String toString() {
        return "(ApplyAction: path = " + this.path + ", outlet = " + this.outletName + ", acceptNotSet = " + this.acceptNotSet + ")";
    }

    public int hashCode() {
        int prime = 31;
        int secondPrime = 1231;
        int thirdPrime = 1237;
        int result = 1;
        result = 31 * result + (this.acceptNotSet ? 1231 : 1237);
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.outletName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApplyAction other = (ApplyAction)obj;
        if (this.acceptNotSet != other.acceptNotSet) {
            return false;
        }
        if (!this.path.equals(other.path)) {
            return false;
        }
        return this.outletName.equals(other.outletName);
    }
}

