/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.template;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.TokenReplacer;
import org.apache.torque.generator.outlet.OutletImpl;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.template.TemplateFilter;
import org.apache.torque.generator.template.TemplateOutlet;

public abstract class TemplateOutletImpl
extends OutletImpl
implements TemplateOutlet {
    private static Log log = LogFactory.getLog(TemplateOutletImpl.class);
    private final Map<String, String> contentMap = new HashMap<String, String>();
    private String path = null;
    private String encoding = null;
    private final ConfigurationProvider configurationProvider;
    private final TemplateFilter templateFilter;
    private static final int LOAD_BUFFER_SIZE = 8192;
    private static final int CONTENT_TO_STRING_MAX_OUTPUT_LENGTH = 40;

    protected TemplateOutletImpl(QualifiedName name, ConfigurationProvider configurationProvider, String path, String encoding, TemplateFilter templateFilter) throws ConfigurationException {
        super(name);
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (path == null) {
            throw new NullPointerException("path must not be null");
        }
        this.configurationProvider = configurationProvider;
        this.path = path;
        this.encoding = encoding;
        this.templateFilter = templateFilter;
    }

    public String getContent(ControllerState controllerState) throws ConfigurationException {
        TokenReplacer tokenReplacer = new TokenReplacer(controllerState);
        String detokenizedPath = tokenReplacer.process(this.path);
        String result = this.contentMap.get(detokenizedPath);
        if (result == null) {
            InputStream templateInputStream = null;
            try {
                templateInputStream = this.configurationProvider.getTemplateInputStream(detokenizedPath);
                result = this.load(templateInputStream, this.encoding, this.templateFilter);
            }
            catch (IOException e) {
                throw new ConfigurationException(e);
            }
            finally {
                if (templateInputStream != null) {
                    try {
                        templateInputStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"Could not close template reader", (Throwable)e);
                    }
                }
            }
            this.contentMap.put(detokenizedPath, result);
        }
        return result;
    }

    protected String load(InputStream inputStream, String encoding, TemplateFilter filter) throws IOException {
        char[] charBuffer;
        int filledChars;
        InputStream filteredStream = filter != null ? filter.filter(inputStream, encoding) : inputStream;
        InputStreamReader reader = encoding == null ? new InputStreamReader(filteredStream) : new InputStreamReader(filteredStream, encoding);
        StringBuffer contentBuffer = new StringBuffer();
        while ((filledChars = reader.read(charBuffer = new char[8192])) != -1) {
            contentBuffer.append(charBuffer, 0, filledChars);
        }
        return contentBuffer.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString()).append(",");
        result.append("encoding=").append(this.encoding).append(",");
        result.append("content=");
        if (!this.contentMap.isEmpty()) {
            String firstContent = this.contentMap.values().iterator().next();
            if (firstContent.length() > 40) {
                result.append(firstContent.substring(0, 40));
            } else {
                result.append(firstContent);
            }
        }
        return result.toString();
    }
}

