/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.controller;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.controller.ControlConfiguration;
import org.apache.torque.generator.configuration.controller.ControlConfigurationSaxHandler;
import org.apache.torque.generator.configuration.paths.ProjectPaths;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ControlConfigurationXmlParser {
    private static SAXParserFactory saxFactory;
    private static Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlConfiguration readControllerConfiguration(ConfigurationProvider configurationProvider, ProjectPaths projectPaths, ConfigurationHandlers configurationHandlers) throws ConfigurationException {
        InputStream controlConfigurationInputStream = configurationProvider.getControlConfigurationInputStream();
        try {
            ControlConfiguration result = new ControlConfiguration();
            try {
                SAXParser parser = saxFactory.newSAXParser();
                InputSource is = new InputSource(controlConfigurationInputStream);
                parser.parse(is, (DefaultHandler)new ControlConfigurationSaxHandler(result, configurationProvider, projectPaths, configurationHandlers));
            }
            catch (SAXParseException e) {
                throw new ConfigurationException("Error parsing controller Configuration " + configurationProvider.getControlConfigurationLocation() + " at line " + e.getLineNumber() + " column " + e.getColumnNumber() + " : " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error parsing controller Configuration " + configurationProvider.getControlConfigurationLocation() + e.getMessage(), e);
            }
            ControlConfiguration controlConfiguration = result;
            return controlConfiguration;
        }
        finally {
            try {
                controlConfigurationInputStream.close();
            }
            catch (IOException e) {
                log.warn((Object)"Could not close controlConfigurationInputStream", (Throwable)e);
            }
        }
    }

    static {
        log = LogFactory.getLog(ControlConfigurationXmlParser.class);
        saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        try {
            saxFactory.setFeature("http://xml.org/sax/features/validation", true);
            saxFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

