/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.jxpath.BasicNodeSet;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.NestedTestBean;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;

public class TestFunctions {
    private int foo;
    private String bar;

    public static TestFunctions build(int foo, String bar) {
        return new TestFunctions(foo, bar);
    }

    public static Collection collection() {
        ArrayList<NestedTestBean> list = new ArrayList<NestedTestBean>();
        list.add(new NestedTestBean("foo"));
        list.add(new NestedTestBean("bar"));
        return list;
    }

    public static int count(ExpressionContext context, Collection col) {
        for (Object element : col) {
            if (element instanceof String) continue;
            throw new IllegalArgumentException("Invalid argument");
        }
        return col.size();
    }

    public static int countPointers(NodeSet nodeSet) {
        return nodeSet.getPointers().size();
    }

    public static Boolean isInstance(Object o, Class c) {
        return c.isInstance(o) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean isMap(ExpressionContext context) {
        Pointer ptr = context.getContextNodePointer();
        return ptr == null ? false : ptr.getValue() instanceof Map;
    }

    public static Collection items(Collection arg) {
        return arg;
    }

    public static NodeSet nodeSet(ExpressionContext context) {
        JXPathContext jxpathCtx = context.getJXPathContext();
        BasicNodeSet set = new BasicNodeSet();
        set.add(jxpathCtx.getPointer("/beans[1]"));
        set.add(jxpathCtx.getPointer("/beans[2]"));
        return set;
    }

    public static String path(ExpressionContext context) {
        return context.getContextNodePointer().asPath();
    }

    public static String string(String string) {
        return string;
    }

    public TestFunctions() {
    }

    public TestFunctions(ExpressionContext context, String bar) {
        this.foo = ((Number)context.getContextNodePointer().getValue()).intValue();
        this.bar = bar;
    }

    public TestFunctions(int foo, Object object, boolean another) {
        this.foo = foo;
        this.bar = String.valueOf(object);
    }

    public TestFunctions(int foo, String bar) {
        this.foo = foo;
        this.bar = bar;
    }

    public String className(ExpressionContext context, ExpressionContext child) {
        return context.getContextNodePointer().asPath();
    }

    public void doit() {
    }

    public String getBar() {
        return this.bar;
    }

    public int getFoo() {
        return this.foo;
    }

    public String instancePath(ExpressionContext context) {
        return context.getContextNodePointer().asPath();
    }

    public String pathWithSuffix(ExpressionContext context, String suffix) {
        return context.getContextNodePointer().asPath() + suffix;
    }

    public TestFunctions setFooAndBar(int foo, String bar) {
        this.foo = foo;
        this.bar = bar;
        return this;
    }

    public String toString() {
        return "foo=" + this.foo + "; bar=" + this.bar;
    }
}

