/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.AscIntegerIterator;
import org.apache.commons.jexl3.internal.AscLongIterator;
import org.apache.commons.jexl3.internal.IntegerRange;
import org.apache.commons.jexl3.internal.LongRange;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.Source;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RangeTest
extends JexlTestCase {
    public RangeTest() {
        super("InternalTest");
    }

    private void checkIteration(IntegerRange ir, int first, int last) throws Exception {
        Iterator ii = ir.iterator();
        if (ii.hasNext()) {
            int l = (Integer)ii.next();
            Assertions.assertEquals((int)first, (int)l);
            while (ii.hasNext()) {
                l = (Integer)ii.next();
            }
            Assertions.assertEquals((int)last, (int)l);
        } else {
            Assertions.fail((String)"empty iterator?");
        }
    }

    private void checkIteration(LongRange lr, long first, long last) throws Exception {
        Iterator ii = lr.iterator();
        if (ii.hasNext()) {
            long l = (Long)ii.next();
            Assertions.assertEquals((long)first, (long)l);
            while (ii.hasNext()) {
                l = (Long)ii.next();
            }
            Assertions.assertEquals((long)last, (long)l);
        } else {
            Assertions.fail((String)"empty iterator?");
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testAscIterator() {
        AscIntegerIterator ii = new AscIntegerIterator(3, 5);
        Integer i = 3;
        while (ii.hasNext()) {
            Assertions.assertEquals((Integer)i, (Integer)((Integer)ii.next()));
            i = i + 1;
        }
        Assertions.assertThrows(NoSuchElementException.class, ((Iterator)ii)::next, (String)"iterator exhausted");
        Assertions.assertThrows(UnsupportedOperationException.class, ((Iterator)ii)::remove, (String)"remove not implemented");
    }

    @Test
    public void testAscLongIterator() {
        AscLongIterator ii = new AscLongIterator(3L, 5L);
        Long i = 3L;
        while (ii.hasNext()) {
            Assertions.assertEquals((Long)i, (Long)((Long)ii.next()));
            i = i + 1L;
        }
        Assertions.assertThrows(NoSuchElementException.class, ((Iterator)ii)::next, (String)"iterator exhausted");
        Assertions.assertThrows(UnsupportedOperationException.class, ((Iterator)ii)::remove, (String)"remove not implemented");
    }

    @Test
    public void testMisc() {
        Assertions.assertEquals((Object)"?", (Object)Scope.UNDEFINED.toString());
        Assertions.assertEquals((Object)"??", (Object)Scope.UNDECLARED.toString());
    }

    @Test
    public void testRanges() throws Exception {
        LongRange lr0 = LongRange.create((long)20L, (long)10L);
        Assertions.assertEquals((long)10L, (long)lr0.getMin());
        Assertions.assertEquals((long)20L, (long)lr0.getMax());
        Assertions.assertFalse((boolean)lr0.isEmpty());
        Assertions.assertTrue((boolean)lr0.contains((Object)10L));
        Assertions.assertTrue((boolean)lr0.contains((Object)20L));
        Assertions.assertFalse((boolean)lr0.contains((Object)30L));
        Assertions.assertFalse((boolean)lr0.contains((Object)5L));
        Assertions.assertFalse((boolean)lr0.contains(null));
        this.checkIteration(lr0, 20L, 10L);
        LongRange lr1 = LongRange.create((long)10L, (long)20L);
        this.checkIteration(lr1, 10L, 20L);
        Assertions.assertTrue((boolean)lr0.containsAll((Collection)lr1));
        LongRange lr2 = LongRange.create((long)10L, (long)15L);
        Assertions.assertNotEquals((Object)lr0, (Object)lr2);
        Assertions.assertTrue((boolean)lr0.containsAll((Collection)lr2));
        Assertions.assertFalse((boolean)lr2.containsAll((Collection)lr1));
        IntegerRange ir0 = IntegerRange.create((int)20, (int)10);
        this.checkIteration(ir0, 20, 10);
        Assertions.assertEquals((int)10, (int)ir0.getMin());
        Assertions.assertEquals((int)20, (int)ir0.getMax());
        Assertions.assertFalse((boolean)ir0.isEmpty());
        Assertions.assertTrue((boolean)ir0.contains((Object)10));
        Assertions.assertTrue((boolean)ir0.contains((Object)20));
        Assertions.assertFalse((boolean)ir0.contains((Object)30));
        Assertions.assertFalse((boolean)ir0.contains((Object)5));
        Assertions.assertFalse((boolean)ir0.contains(null));
        IntegerRange ir1 = IntegerRange.create((int)10, (int)20);
        this.checkIteration(ir1, 10, 20);
        Assertions.assertTrue((boolean)ir0.containsAll((Collection)ir1));
        Assertions.assertNotEquals((Object)ir0, (Object)lr0);
        Assertions.assertNotEquals((Object)ir1, (Object)lr1);
        IntegerRange ir2 = IntegerRange.create((int)10, (int)15);
        Assertions.assertNotEquals((Object)ir0, (Object)ir2);
        Assertions.assertTrue((boolean)ir0.containsAll((Collection)ir2));
        Assertions.assertFalse((boolean)ir2.containsAll((Collection)ir1));
        long lc0 = 20L;
        Iterator il0 = lr0.iterator();
        while (il0.hasNext()) {
            long v0 = (Long)il0.next();
            Assertions.assertEquals((long)lc0, (long)v0);
            try {
                switch ((int)v0) {
                    case 10: {
                        il0.remove();
                        Assertions.fail();
                        break;
                    }
                    case 11: {
                        lr1.add(Long.valueOf(v0));
                        Assertions.fail();
                        break;
                    }
                    case 12: {
                        lr1.remove((Object)v0);
                        Assertions.fail();
                        break;
                    }
                    case 13: {
                        lr1.addAll(Collections.singletonList(v0));
                        Assertions.fail();
                        break;
                    }
                    case 14: {
                        lr1.removeAll(Collections.singletonList(v0));
                        Assertions.fail();
                        break;
                    }
                    case 15: {
                        lr1.retainAll(Collections.singletonList(v0));
                        Assertions.fail();
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            --lc0;
        }
        Assertions.assertEquals((long)9L, (long)lc0);
        Assertions.assertThrows(NoSuchElementException.class, il0::next);
        int ic0 = 20;
        Iterator ii0 = ir0.iterator();
        while (ii0.hasNext()) {
            int v0 = (Integer)ii0.next();
            Assertions.assertEquals((int)ic0, (int)v0);
            try {
                switch (v0) {
                    case 10: {
                        ii0.remove();
                        Assertions.fail();
                        break;
                    }
                    case 11: {
                        ir1.add(Integer.valueOf(v0));
                        Assertions.fail();
                        break;
                    }
                    case 12: {
                        ir1.remove((Object)v0);
                        Assertions.fail();
                        break;
                    }
                    case 13: {
                        ir1.addAll(Collections.singletonList(v0));
                        Assertions.fail();
                        break;
                    }
                    case 14: {
                        ir1.removeAll(Collections.singletonList(v0));
                        Assertions.fail();
                        break;
                    }
                    case 15: {
                        ir1.retainAll(Collections.singletonList(v0));
                        Assertions.fail();
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            --ic0;
        }
        Assertions.assertEquals((int)9, (int)ic0);
        Assertions.assertThrows(NoSuchElementException.class, ii0::next);
    }

    @Test
    public void testSource() {
        JexlFeatures features = JexlFeatures.createDefault();
        Source src0 = new Source(features, "x -> -x");
        Source src0b = new Source(features, "x -> -x");
        Source src1 = new Source(features, "x -> +x");
        Assertions.assertEquals((int)7, (int)src0.length());
        Assertions.assertEquals((Object)src0, (Object)src0);
        Assertions.assertEquals((Object)src0, (Object)src0b);
        Assertions.assertNotEquals((Object)src0, (Object)src1);
        Assertions.assertEquals((int)src0.hashCode(), (int)src0b.hashCode());
        Assertions.assertNotEquals((int)src0.hashCode(), (int)src1.hashCode());
        Assertions.assertTrue((src0.compareTo(src0b) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((src0.compareTo(src1) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((src1.compareTo(src0) < 0 ? 1 : 0) != 0);
    }
}

