/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.examples;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamTest {
    private final JexlEngine jexl;

    public StreamTest() {
        JexlFeatures features = new JexlFeatures().loops(false).sideEffectGlobal(false).sideEffect(false);
        JexlPermissions.ClassPermissions permissions = new JexlPermissions.ClassPermissions(new Class[]{URI.class});
        this.jexl = new JexlBuilder().features(features).permissions((JexlPermissions)permissions).namespaces(Collections.singletonMap("URI", URI.class)).create();
    }

    @Test
    public void testURICollection() {
        CollectionContext sctxt = new CollectionContext();
        List<URI> uris = Arrays.asList(URI.create("http://user@www.apache.org:8000?qry=true"), URI.create("https://commons.apache.org/releases/prepare.html"), URI.create("mailto:henrib@apache.org"));
        JexlScript filter = this.jexl.createScript("list.filter(uri -> uri.scheme =^ 'http')", new String[]{"list"});
        Object filtered = filter.execute((JexlContext)sctxt, new Object[]{uris});
        Assertions.assertInstanceOf(List.class, (Object)filtered);
        List result = (List)filtered;
        Assertions.assertEquals((int)2, (int)result.size());
        for (URI uri : result) {
            Assertions.assertTrue((boolean)uri.getScheme().startsWith("http"));
        }
        JexlScript mapper = this.jexl.createScript("list.map(uri -> uri.scheme =^ 'http'? URI:create(`https://${uri.host}`) : null)", new String[]{"list"});
        Object transformed = mapper.execute((JexlContext)sctxt, new Object[]{uris});
        Assertions.assertInstanceOf(List.class, (Object)transformed);
        result = (List)transformed;
        Assertions.assertEquals((int)2, (int)result.size());
        for (URI uri : result) {
            Assertions.assertEquals((Object)"https", (Object)uri.getScheme());
        }
    }

    @Test
    public void testURIStream() {
        List<URI> uris = Arrays.asList(URI.create("http://user@www.apache.org:8000?qry=true"), URI.create("https://commons.apache.org/releases/prepare.html"), URI.create("mailto:henrib@apache.org"));
        List control = uris.stream().map(uri -> uri.getScheme().startsWith("http") ? "https://" + uri.getHost() : null).filter(Objects::nonNull).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)control.size());
        JexlScript mapper = this.jexl.createScript("uri.scheme =^ 'http'? `https://${uri.host}` : null", new String[]{"uri"});
        JexlScript transform = this.jexl.createScript("list.stream().map(mapper).filter(x -> !!x).collect(Collectors.toList())", new String[]{"list"});
        StreamContext sctxt = new StreamContext();
        sctxt.set("Collectors", Collectors.class);
        sctxt.set("mapper", mapper);
        Object transformed = transform.execute((JexlContext)sctxt, new Object[]{uris});
        Assertions.assertInstanceOf(List.class, (Object)transformed);
        Assertions.assertEquals(control, (Object)transformed);
    }

    public static class CollectionContext
    extends MapContext {
        public List<?> filter(Collection<?> collection, JexlScript filter) {
            return collection.stream().filter(x -> x != null && Boolean.TRUE.equals(filter.execute((JexlContext)this, new Object[]{x}))).collect(Collectors.toList());
        }

        public List<?> map(Collection<?> collection, JexlScript mapper) {
            return collection.stream().map(x -> mapper.execute((JexlContext)this, new Object[]{x})).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    public static class StreamContext
    extends MapContext {
        public Stream<?> filter(Stream<?> stream, JexlScript filter) {
            return stream.filter(x -> x != null && Boolean.TRUE.equals(filter.execute((JexlContext)this, new Object[]{x})));
        }

        public Stream<?> map(Stream<?> stream, JexlScript mapper) {
            return stream.map(x -> mapper.execute((JexlContext)this, new Object[]{x}));
        }
    }
}

