/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlTestCase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CacheTest
extends JexlTestCase {
    private static final int LOOPS = 4096;
    private static final int NTHREADS = 4;
    private static final int[] MIX = new int[]{0, 0, 3, 3, 4, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 2, 2, 3, 3, 0};
    private static final JexlEngine jexlCache = new JexlBuilder().cache(1024).debug(true).strict(true).create();
    private static final JexlEngine jexlNoCache = new JexlBuilder().cache(0).debug(true).strict(true).create();
    private static JexlEngine jexl = jexlCache;

    public CacheTest() {
        super("CacheTest", null);
    }

    void doCOMPUTE(TestCacheArguments x, int loops, boolean cache) throws Exception {
        if (loops == 0) {
            loops = MIX.length;
        }
        if (!cache) {
            jexl.clearCache();
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        HashMap<String, Object> funcs = new HashMap<String, Object>();
        JexlContextNS jc = new JexlContextNS(vars, funcs);
        JexlExpression compute2 = jexl.createExpression("cached:COMPUTE(a0, a1)");
        JexlExpression compute1 = jexl.createExpression("cached:COMPUTE(a0)");
        Object result = null;
        String expected = null;
        for (int l = 0; l < loops; ++l) {
            int mix = MIX[l % MIX.length] % x.ca.length;
            Object value = x.value[l % x.value.length];
            funcs.put("cached", x.ca[mix]);
            if (value instanceof String) {
                vars.put("a0", "S0");
                vars.put("a1", "S1");
                expected = "CACHED@s#S0,s#S1";
            } else if (value instanceof Integer) {
                vars.put("a0", 7);
                vars.put("a1", 9);
                expected = "CACHED@i#7,i#9";
            } else {
                Assertions.fail((String)"unexpected value type");
            }
            result = compute2.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)expected, (Object)result, () -> ((JexlExpression)compute2).toString());
            if (value instanceof String) {
                vars.put("a0", "X0");
                expected = "CACHED@s#X0";
            } else if (value instanceof Integer) {
                vars.put("a0", 5);
                expected = "CACHED@i#5";
            } else {
                Assertions.fail((String)"unexpected value type");
            }
            result = compute1.evaluate((JexlContext)jc);
            Assertions.assertEquals((Object)expected, (Object)result, () -> ((JexlExpression)compute1).toString());
        }
    }

    void runThreaded(Class<? extends Task> ctask, int loops, boolean cache) throws Exception {
        if (loops == 0) {
            loops = MIX.length;
        }
        jexl = !cache ? jexlNoCache : jexlCache;
        ExecutorService execs = Executors.newFixedThreadPool(4);
        ArrayList<Callable> tasks = new ArrayList<Callable>(4);
        for (int t = 0; t < 4; ++t) {
            tasks.add((Callable)jexl.newInstance(ctask, new Object[]{loops}));
        }
        List futures = execs.invokeAll(tasks, 60L, TimeUnit.SECONDS);
        for (Future future : futures) {
            Assertions.assertEquals((Integer)loops, (Integer)((Integer)future.get()));
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        CacheTest.debuggerCheck(jexl);
    }

    @Test
    public void testAssignBooleanCache() throws Exception {
        this.runThreaded(AssignBooleanTask.class, 4096, true);
    }

    @Test
    public void testAssignBooleanNoCache() throws Exception {
        this.runThreaded(AssignBooleanTask.class, 4096, false);
    }

    @Test
    public void testAssignCache() throws Exception {
        this.runThreaded(AssignTask.class, 4096, true);
    }

    @Test
    public void testAssignListCache() throws Exception {
        this.runThreaded(AssignListTask.class, 4096, true);
    }

    @Test
    public void testAssignListNoCache() throws Exception {
        this.runThreaded(AssignListTask.class, 4096, false);
    }

    @Test
    public void testAssignNoCache() throws Exception {
        this.runThreaded(AssignTask.class, 4096, false);
    }

    @Test
    public void testComputeCache() throws Exception {
        this.runThreaded(ComputeTask.class, 4096, true);
    }

    @Test
    public void testCOMPUTECache() throws Exception {
        TestCacheArguments args = new TestCacheArguments();
        args.ca = new Object[]{Cached.class, Cached1.class, Cached2.class};
        args.value = new Object[]{2, "quux"};
        this.doCOMPUTE(args, 4096, true);
    }

    @Test
    public void testComputeNoCache() throws Exception {
        this.runThreaded(ComputeTask.class, 4096, false);
    }

    @Test
    public void testCOMPUTENoCache() throws Exception {
        TestCacheArguments args = new TestCacheArguments();
        args.ca = new Object[]{Cached.class, Cached1.class, Cached2.class};
        args.value = new Object[]{2, "quux"};
        this.doCOMPUTE(args, 4096, false);
    }

    @Test
    public void testNullAssignCache() throws Exception {
        this.runThreaded(AssignNullTask.class, 4096, true);
    }

    @Test
    public void testNullAssignNoCache() throws Exception {
        this.runThreaded(AssignNullTask.class, 4096, false);
    }

    public static class JexlContextNS
    extends JexlEvalContext {
        final Map<String, Object> funcs;

        JexlContextNS(Map<String, Object> vars, Map<String, Object> funcs) {
            super(vars);
            this.funcs = funcs;
        }

        @Override
        public Object resolveNamespace(String name) {
            return this.funcs.get(name);
        }
    }

    static class TestCacheArguments {
        Cached0 c0 = new Cached0();
        Cached1 c1 = new Cached1();
        Cached2 c2 = new Cached2();
        Cached3 c3 = new Cached3();
        Cached4 c4 = new Cached4();
        Object[] ca = new Object[]{this.c0, this.c1, this.c2, this.c3, this.c4};
        Object[] value;

        TestCacheArguments() {
        }
    }

    public static class AssignBooleanTask
    extends Task {
        public AssignBooleanTask(int loops) {
            super(loops);
        }

        @Override
        public Integer call() throws Exception {
            return this.runAssignBoolean(Boolean.TRUE);
        }

        private Integer runAssignBoolean(Boolean value) {
            this.args.value = new Object[]{value};
            JexlExpression cacheGetValue = jexl.createExpression("cache.flag");
            JexlExpression cacheSetValue = jexl.createExpression("cache.flag = value");
            for (int l = 0; l < this.loops; ++l) {
                int px = (int)Thread.currentThread().getId();
                int mix = MIX[(l + px) % MIX.length];
                this.vars.put("cache", this.args.ca[mix]);
                this.vars.put("value", this.args.value[0]);
                Object result = cacheSetValue.evaluate((JexlContext)this.jc);
                Assertions.assertEquals((Object)this.args.value[0], (Object)result, () -> ((JexlExpression)cacheSetValue).toString());
                result = cacheGetValue.evaluate((JexlContext)this.jc);
                Assertions.assertEquals((Object)this.args.value[0], (Object)result, () -> ((JexlExpression)cacheSetValue).toString());
            }
            return this.loops;
        }
    }

    public static class AssignTask
    extends Task {
        public AssignTask(int loops) {
            super(loops);
        }

        @Override
        public Integer call() throws Exception {
            return this.runAssign("foo");
        }
    }

    public static class AssignListTask
    extends Task {
        public AssignListTask(int loops) {
            super(loops);
        }

        @Override
        public Integer call() throws Exception {
            return this.runAssignList();
        }

        private Integer runAssignList() {
            this.args.value = new Object[]{"foo"};
            ArrayList<String> c1 = new ArrayList<String>(2);
            c1.add("foo");
            c1.add("bar");
            this.args.ca = new Object[]{new String[]{"one", "two"}, c1};
            JexlExpression cacheGetValue = jexl.createExpression("cache.0");
            JexlExpression cacheSetValue = jexl.createExpression("cache[0] = value");
            for (int l = 0; l < this.loops; ++l) {
                int px = (int)Thread.currentThread().getId();
                int mix = MIX[(l + px) % MIX.length] % this.args.ca.length;
                this.vars.put("cache", this.args.ca[mix]);
                this.vars.put("value", this.args.value[0]);
                Object result = cacheSetValue.evaluate((JexlContext)this.jc);
                Assertions.assertEquals((Object)this.args.value[0], (Object)result, () -> ((JexlExpression)cacheSetValue).toString());
                result = cacheGetValue.evaluate((JexlContext)this.jc);
                Assertions.assertEquals((Object)this.args.value[0], (Object)result, () -> ((JexlExpression)cacheGetValue).toString());
            }
            return this.loops;
        }
    }

    public static class ComputeTask
    extends Task {
        public ComputeTask(int loops) {
            super(loops);
        }

        @Override
        public Integer call() throws Exception {
            this.args.ca = new Object[]{this.args.c0, this.args.c1, this.args.c2};
            this.args.value = new Object[]{2, "quux"};
            JexlExpression compute2 = jexl.createExpression("cache.compute(a0, a1)");
            JexlExpression compute1 = jexl.createExpression("cache.compute(a0)");
            JexlExpression compute1null = jexl.createExpression("cache.compute(a0)");
            JexlExpression ambiguous = jexl.createExpression("cache.ambiguous(a0, a1)");
            Object result = null;
            String expected = null;
            for (int l = 0; l < this.loops; ++l) {
                int mix = MIX[l % MIX.length] % this.args.ca.length;
                Object value = this.args.value[l % this.args.value.length];
                this.vars.put("cache", this.args.ca[mix]);
                if (value instanceof String) {
                    this.vars.put("a0", "S0");
                    this.vars.put("a1", "S1");
                    expected = "Cached" + mix + "@s#S0,s#S1";
                } else if (value instanceof Integer) {
                    this.vars.put("a0", 7);
                    this.vars.put("a1", 9);
                    expected = "Cached" + mix + "@i#7,i#9";
                } else {
                    Assertions.fail((String)"unexpected value type");
                }
                result = compute2.evaluate((JexlContext)this.jc);
                Assertions.assertEquals(expected, (Object)result, () -> ((JexlExpression)compute2).toString());
                if (value instanceof Integer) {
                    this.vars.put("a0", (short)17);
                    this.vars.put("a1", (short)19);
                    Assertions.assertThrows(JexlException.class, () -> ambiguous.evaluate((JexlContext)this.jc));
                }
                if (value instanceof String) {
                    this.vars.put("a0", "X0");
                    expected = "Cached" + mix + "@s#X0";
                } else if (value instanceof Integer) {
                    this.vars.put("a0", 5);
                    expected = "Cached" + mix + "@i#5";
                } else {
                    Assertions.fail((String)"unexpected value type");
                }
                result = compute1.evaluate((JexlContext)this.jc);
                Assertions.assertEquals((Object)expected, (Object)result, () -> ((JexlExpression)compute1).toString());
                this.vars.put("a0", null);
                JexlException xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> compute1null.evaluate((JexlContext)this.jc));
                String sany = xany.getMessage();
                String tname = this.getClass().getName();
                if (sany.startsWith(tname)) continue;
                Assertions.fail((String)("debug mode should carry caller information, " + sany + ", " + tname));
            }
            return this.loops;
        }
    }

    public static class Cached {
        public static String COMPUTE(int arg) {
            return "CACHED@i#" + arg;
        }

        public static String COMPUTE(int arg0, int arg1) {
            return "CACHED@i#" + arg0 + ",i#" + arg1;
        }

        public static String COMPUTE(String arg) {
            if (arg == null) {
                arg = "na";
            }
            return "CACHED@s#" + arg;
        }

        public static String COMPUTE(String arg0, String arg1) {
            if (arg0 == null) {
                arg0 = "na";
            }
            if (arg1 == null) {
                arg1 = "na";
            }
            return "CACHED@s#" + arg0 + ",s#" + arg1;
        }

        public String ambiguous(int arg0, Integer arg1) {
            return this.getClass().getSimpleName() + "!i#" + arg0 + ",i#" + arg1;
        }

        public String ambiguous(Integer arg0, int arg1) {
            return this.getClass().getSimpleName() + "!i#" + arg0 + ",i#" + arg1;
        }

        public String compute(float arg) {
            return this.getClass().getSimpleName() + "@f#" + arg;
        }

        public String compute(int arg0, int arg1) {
            return this.getClass().getSimpleName() + "@i#" + arg0 + ",i#" + arg1;
        }

        public String compute(Integer arg) {
            return this.getClass().getSimpleName() + "@i#" + arg;
        }

        public String compute(String arg) {
            if (arg == null) {
                arg = "na";
            }
            return this.getClass().getSimpleName() + "@s#" + arg;
        }

        public String compute(String arg0, String arg1) {
            if (arg0 == null) {
                arg0 = "na";
            }
            if (arg1 == null) {
                arg1 = "na";
            }
            return this.getClass().getSimpleName() + "@s#" + arg0 + ",s#" + arg1;
        }
    }

    public static class Cached1
    extends Cached0 {
        @Override
        public void setValue(String arg) {
            if (arg == null) {
                arg = "na";
            }
            this.value = "Cached1:" + arg;
        }
    }

    public static class Cached2
    extends Cached {
        boolean flag;
        protected String value = "Cached2:new";

        public Object get(String prop) {
            if ("value".equals(prop)) {
                return this.value;
            }
            if ("flag".equals(prop)) {
                return this.flag;
            }
            throw new IllegalArgumentException("no such property");
        }

        public void set(String p, Object v) {
            if (v == null) {
                v = "na";
            }
            if ("value".equals(p)) {
                this.value = this.getClass().getSimpleName() + ":" + v;
            } else if ("flag".equals(p)) {
                this.flag = Boolean.parseBoolean(v.toString());
            } else {
                throw new IllegalArgumentException("no such property");
            }
        }
    }

    public static class AssignNullTask
    extends Task {
        public AssignNullTask(int loops) {
            super(loops);
        }

        @Override
        public Integer call() throws Exception {
            return this.runAssign(null);
        }
    }

    public static abstract class Task
    implements Callable<Integer> {
        final TestCacheArguments args = new TestCacheArguments();
        final int loops;
        final Map<String, Object> vars = new HashMap<String, Object>();
        final JexlEvalContext jc = new JexlEvalContext(this.vars);

        Task(int loops) {
            this.loops = loops;
        }

        @Override
        public abstract Integer call() throws Exception;

        public Integer runAssign(Object value) {
            this.args.value = new Object[]{value};
            JexlExpression cacheGetValue = jexl.createExpression("cache.value");
            JexlExpression cacheSetValue = jexl.createExpression("cache.value = value");
            for (int l = 0; l < this.loops; ++l) {
                int px = (int)Thread.currentThread().getId();
                int mix = MIX[(l + px) % MIX.length];
                this.vars.put("cache", this.args.ca[mix]);
                this.vars.put("value", this.args.value[0]);
                Object result = cacheSetValue.evaluate((JexlContext)this.jc);
                if (this.args.value[0] == null) {
                    Assertions.assertNull((Object)result);
                } else {
                    Assertions.assertEquals((Object)this.args.value[0], (Object)result, () -> ((JexlExpression)cacheSetValue).toString());
                }
                result = cacheGetValue.evaluate((JexlContext)this.jc);
                if (this.args.value[0] == null) {
                    Assertions.assertEquals((Object)("Cached" + mix + ":na"), (Object)result, () -> ((JexlExpression)cacheGetValue).toString());
                    continue;
                }
                Assertions.assertEquals((Object)("Cached" + mix + ":" + this.args.value[0]), (Object)result, () -> ((JexlExpression)cacheGetValue).toString());
            }
            return this.loops;
        }
    }

    public static class Cached4
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;

        public Cached4() {
            super.add("Cached4:new");
            super.add("false");
        }

        public String getValue() {
            return (String)super.get(0);
        }

        public boolean isflag() {
            return Boolean.parseBoolean((String)super.get(1));
        }

        public void setflag(Boolean b) {
            super.set(1, b.toString());
        }

        public void setValue(String arg) {
            if (arg == null) {
                arg = "na";
            }
            super.set(0, "Cached4:" + arg);
        }
    }

    public static class Cached3
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = 1L;
        boolean flag;

        public Cached3() {
            this.put("value", (Object)"Cached3:new");
            this.put("flag", (Object)"false");
        }

        @Override
        public Object get(Object key) {
            return super.get(key.toString());
        }

        public boolean isflag() {
            return this.flag;
        }

        @Override
        public final Object put(String key, Object arg) {
            if (arg == null) {
                arg = "na";
            }
            arg = "Cached3:" + arg;
            return super.put(key, arg);
        }

        public void setflag(boolean b) {
            this.flag = b;
        }
    }

    public static class Cached0
    extends Cached {
        protected String value = "Cached0:new";
        protected Boolean flag = Boolean.FALSE;

        public String getValue() {
            return this.value;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean b) {
            this.flag = b;
        }

        public void setValue(String arg) {
            if (arg == null) {
                arg = "na";
            }
            this.value = "Cached0:" + arg;
        }
    }
}

