/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigInteger;
import java.math.MathContext;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlOperator;

public class Arithmetic360
extends JexlArithmetic {
    public Arithmetic360(boolean astrict) {
        super(astrict);
    }

    public Arithmetic360(boolean astrict, MathContext bigdContext, int bigdScale) {
        super(astrict, bigdContext, bigdScale);
    }

    public Object and(Object left, Object right) {
        Number l = this.asLongNumber(left);
        Number r = this.asLongNumber(right);
        if (l != null && r != null) {
            return this.narrowLong(left, right, l.longValue() & r.longValue());
        }
        return this.toBigInteger(left).and(this.toBigInteger(right));
    }

    protected Number asIntNumber(Object value) {
        return value instanceof Integer || value instanceof Short || value instanceof Byte ? (Number)value : null;
    }

    protected Long castLongNumber(Object value) {
        return value instanceof Long ? (Long)value : null;
    }

    public Object complement(Object val) {
        long l = this.toLong(val);
        return this.narrowLong(val, l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    protected Number narrowLong(Object operand, long result) {
        int ir;
        if (!(operand instanceof Long) && result == (long)(ir = (int)result)) {
            return ir;
        }
        return result;
    }

    protected Number narrowLong(Object lhs, Object rhs, long result) {
        int ir;
        if (!(lhs instanceof Long) && !(rhs instanceof Long) && result == (long)(ir = (int)result)) {
            return ir;
        }
        return result;
    }

    public Object or(Object left, Object right) {
        Number l = this.asLongNumber(left);
        Number r = this.asLongNumber(right);
        if (l != null && r != null) {
            return this.narrowLong(left, right, l.longValue() | r.longValue());
        }
        return this.toBigInteger(left).or(this.toBigInteger(right));
    }

    public Object shiftLeft(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.SHIFTLEFT);
        }
        int r = this.toInteger(right);
        Number l = this.asIntNumber(left);
        if (l != null) {
            return l.intValue() << r;
        }
        l = this.castLongNumber(left);
        if (l != null) {
            return l.longValue() << r;
        }
        return this.toBigInteger(left).shiftLeft(r);
    }

    public Object shiftRight(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.SHIFTRIGHT);
        }
        int r = this.toInteger(right);
        Number l = this.asIntNumber(left);
        if (l != null) {
            return l.intValue() >> r;
        }
        l = this.castLongNumber(left);
        if (l != null) {
            return l.longValue() >> r;
        }
        return this.toBigInteger(left).shiftRight(r);
    }

    public Object shiftRightUnsigned(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.SHIFTRIGHTU);
        }
        int r = this.toInteger(right);
        Number l = this.asIntNumber(left);
        if (l != null) {
            return l.intValue() >>> r;
        }
        l = this.castLongNumber(left);
        if (l != null) {
            return l.longValue() >>> r;
        }
        BigInteger bl = this.toBigInteger(left);
        return bl.signum() < 0 ? bl.negate().shiftRight(r) : bl.shiftRight(r);
    }

    public Object xor(Object left, Object right) {
        Number l = this.asLongNumber(left);
        Number r = this.asLongNumber(right);
        if (l != null && r != null) {
            return this.narrowLong(left, right, l.longValue() ^ r.longValue());
        }
        return this.toBigInteger(left).xor(this.toBigInteger(right));
    }
}

