/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.dbutils.Column;
import org.apache.commons.dbutils.ColumnHandler;
import org.apache.commons.dbutils.PropertyHandler;

public class BeanProcessor {
    protected static final int PROPERTY_NOT_FOUND = -1;
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = new HashMap();
    private static final List<ColumnHandler<?>> COLUMN_HANDLERS = new ArrayList();
    private static final List<PropertyHandler> PROPERTY_HANDLERS = new ArrayList<PropertyHandler>();
    private final Map<String, String> columnToPropertyOverrides;

    public BeanProcessor() {
        this(new HashMap<String, String>());
    }

    public BeanProcessor(Map<String, String> columnToPropertyOverrides) {
        if (columnToPropertyOverrides == null) {
            throw new IllegalArgumentException("columnToPropertyOverrides map cannot be null");
        }
        this.columnToPropertyOverrides = columnToPropertyOverrides;
    }

    private void callSetter(Object target, PropertyDescriptor prop, Object value) throws SQLException {
        Method setter = this.getWriteMethod(target, prop, value);
        if (setter == null || setter.getParameterTypes().length != 1) {
            return;
        }
        try {
            Class<?> firstParam = setter.getParameterTypes()[0];
            for (PropertyHandler handler : PROPERTY_HANDLERS) {
                if (!handler.match(firstParam, value)) continue;
                value = handler.apply(firstParam, value);
                break;
            }
            if (!this.isCompatibleType(value, firstParam)) {
                throw new SQLException("Cannot set " + prop.getName() + ": incompatible types, cannot convert " + value.getClass().getName() + " to " + firstParam.getName());
            }
            setter.invoke(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
    }

    private <T> T createBean(ResultSet resultSet, Class<T> type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        return this.populateBean(resultSet, this.newInstance(type), props, columnToProperty);
    }

    protected Method getWriteMethod(Object target, PropertyDescriptor prop, Object value) {
        return prop.getWriteMethod();
    }

    private boolean isCompatibleType(Object value, Class<?> type) {
        return value == null || type.isInstance(value) || this.matchesPrimitive(type, value.getClass());
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String propertyName;
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            if ((propertyName = this.columnToPropertyOverrides.get(columnName)) == null) {
                propertyName = columnName;
            }
            if (propertyName == null) {
                propertyName = Integer.toString(col);
            }
            for (int i = 0; i < props.length; ++i) {
                PropertyDescriptor prop = props[i];
                Method reader = prop.getReadMethod();
                Column column = reader != null ? reader.getAnnotation(Column.class) : null;
                String propertyColumnName = column != null ? column.name() : prop.getName();
                if (!propertyName.equalsIgnoreCase(propertyColumnName)) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }

    private boolean matchesPrimitive(Class<?> targetType, Class<?> valueType) {
        if (!targetType.isPrimitive()) {
            return false;
        }
        try {
            Field typeField = valueType.getField("TYPE");
            Object primitiveValueType = typeField.get(valueType);
            if (targetType == primitiveValueType) {
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    protected <T> T newInstance(Class<T> c) throws SQLException {
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
    }

    public <T> T populateBean(ResultSet resultSet, T bean) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(bean.getClass());
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        return this.populateBean(resultSet, bean, props, columnToProperty);
    }

    private <T> T populateBean(ResultSet resultSet, T bean, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        for (int i = 1; i < columnToProperty.length; ++i) {
            if (columnToProperty[i] == -1) continue;
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<?> propType = prop.getPropertyType();
            Object value = null;
            if (propType != null && (value = this.processColumn(resultSet, i, propType)) == null && propType.isPrimitive()) {
                value = PRIMITIVE_DEFAULTS.get(propType);
            }
            this.callSetter(bean, prop, value);
        }
        return bean;
    }

    protected Object processColumn(ResultSet resultSet, int index, Class<?> propType) throws SQLException {
        Object retval = resultSet.getObject(index);
        if (!propType.isPrimitive() && retval == null) {
            return null;
        }
        for (ColumnHandler<?> handler : COLUMN_HANDLERS) {
            if (!handler.match(propType)) continue;
            retval = handler.apply(resultSet, index);
            break;
        }
        return retval;
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    public <T> T toBean(ResultSet rs, Class<? extends T> type) throws SQLException {
        T bean = this.newInstance(type);
        return this.populateBean(rs, bean);
    }

    public <T> List<T> toBeanList(ResultSet resultSet, Class<? extends T> type) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        if (!resultSet.next()) {
            return results;
        }
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        do {
            results.add(this.createBean(resultSet, type, props, columnToProperty));
        } while (resultSet.next());
        return results;
    }

    static {
        PRIMITIVE_DEFAULTS.put(Integer.TYPE, 0);
        PRIMITIVE_DEFAULTS.put(Short.TYPE, (short)0);
        PRIMITIVE_DEFAULTS.put(Byte.TYPE, (byte)0);
        PRIMITIVE_DEFAULTS.put(Float.TYPE, Float.valueOf(0.0f));
        PRIMITIVE_DEFAULTS.put(Double.TYPE, 0.0);
        PRIMITIVE_DEFAULTS.put(Long.TYPE, 0L);
        PRIMITIVE_DEFAULTS.put(Boolean.TYPE, Boolean.FALSE);
        PRIMITIVE_DEFAULTS.put(Character.TYPE, Character.valueOf('\u0000'));
        ServiceLoader.load(ColumnHandler.class).forEach(COLUMN_HANDLERS::add);
        ServiceLoader.load(PropertyHandler.class).forEach(PROPERTY_HANDLERS::add);
    }
}

