/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.RowProcessor;

public class BasicRowProcessor
implements RowProcessor {
    private static final BeanProcessor defaultConvert = new BeanProcessor();
    private static final BasicRowProcessor instance = new BasicRowProcessor();
    private final BeanProcessor convert;

    protected static Map<String, Object> createCaseInsensitiveHashMap(int cols) {
        return new CaseInsensitiveHashMap(cols);
    }

    @Deprecated
    public static BasicRowProcessor instance() {
        return instance;
    }

    public BasicRowProcessor() {
        this(defaultConvert);
    }

    public BasicRowProcessor(BeanProcessor convert) {
        this.convert = convert;
    }

    @Override
    public Object[] toArray(ResultSet resultSet) throws SQLException {
        ResultSetMetaData meta = resultSet.getMetaData();
        int cols = meta.getColumnCount();
        Object[] result = new Object[cols];
        for (int i = 0; i < cols; ++i) {
            result[i] = resultSet.getObject(i + 1);
        }
        return result;
    }

    @Override
    public <T> T toBean(ResultSet resultSet, Class<? extends T> type) throws SQLException {
        return this.convert.toBean(resultSet, type);
    }

    @Override
    public <T> List<T> toBeanList(ResultSet resultSet, Class<? extends T> type) throws SQLException {
        return this.convert.toBeanList(resultSet, type);
    }

    @Override
    public Map<String, Object> toMap(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int cols = rsmd.getColumnCount();
        Map<String, Object> result = BasicRowProcessor.createCaseInsensitiveHashMap(cols);
        for (int i = 1; i <= cols; ++i) {
            String propKey = rsmd.getColumnLabel(i);
            if (null == propKey || 0 == propKey.length()) {
                propKey = rsmd.getColumnName(i);
            }
            if (null == propKey || 0 == propKey.length()) {
                propKey = Integer.toString(i);
            }
            result.put(propKey, resultSet.getObject(i));
        }
        return result;
    }

    private static final class CaseInsensitiveHashMap
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = -2848100435296897392L;
        private final Map<String, String> lowerCaseMap = new HashMap<String, String>();

        private CaseInsensitiveHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public boolean containsKey(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.containsKey(realKey);
        }

        @Override
        public Object get(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase(Locale.ENGLISH));
            return super.get(realKey);
        }

        @Override
        public Object put(String key, Object value) {
            String oldKey = this.lowerCaseMap.put(key.toLowerCase(Locale.ENGLISH), key);
            Object oldValue = super.remove(oldKey);
            super.put(key, value);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            m.forEach(this::put);
        }

        @Override
        public Object remove(Object key) {
            String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase(Locale.ENGLISH));
            return super.remove(realKey);
        }
    }
}

