/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BZip2Compress651Test {
    BZip2Compress651Test() {
    }

    @Test
    void testCompress651() throws IOException {
        int buffersize = 102400;
        Path pathIn = Paths.get("src/test/resources/org/apache/commons/compress/COMPRESS-651/my10m.tar.bz2", new String[0]);
        Path pathOut = Paths.get("target/COMPRESS-651/test.tar", new String[0]);
        Files.createDirectories(pathOut.getParent(), new FileAttribute[0]);
        try (BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(pathIn, new OpenOption[0])), true);
             OutputStream outputStream = Files.newOutputStream(pathOut, new OpenOption[0]);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream, (int)102400);
        }
        Assertions.assertEquals((long)10496000L, (long)Files.size(pathOut));
    }
}

