/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractAnyAllOnePredicateTest;
import org.apache.commons.collections4.functors.AllPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AllPredicateTest
extends AbstractAnyAllOnePredicateTest<Integer> {
    public AllPredicateTest() {
        super(42);
    }

    @Override
    protected final Predicate<Integer> getPredicateInstance(Collection<Predicate<Integer>> predicates) {
        return AllPredicate.allPredicate(predicates);
    }

    @Override
    protected final Predicate<Integer> getPredicateInstance(Predicate<? super Integer> ... predicates) {
        return AllPredicate.allPredicate(predicates);
    }

    @Test
    public void testAllTrue() {
        Assertions.assertTrue((boolean)this.getPredicateInstance(true, true).evaluate((Object)((Integer)this.getTestValue())), (String)"multiple true predicates evaluated to false");
        Assertions.assertTrue((boolean)this.getPredicateInstance(true, true, true).evaluate((Object)((Integer)this.getTestValue())), (String)"multiple true predicates evaluated to false");
    }

    @Test
    public void testEmptyArrayToGetInstance() {
        Assertions.assertTrue((boolean)this.getPredicateInstance((Predicate<? super Integer>[])new Predicate[0]).evaluate(null), (String)"empty array not true");
    }

    @Test
    public void testEmptyCollectionToGetInstance() {
        Predicate<Integer> allPredicate = this.getPredicateInstance((Collection<Predicate<Integer>>)Collections.emptyList());
        Assertions.assertTrue((boolean)allPredicate.evaluate((Object)((Integer)this.getTestValue())), (String)"empty collection not true");
    }

    @Test
    public void testOneFalsePredicate() {
        Predicate predicate = this.createMockPredicate(false);
        Assertions.assertFalse((boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{predicate}).test((Object)((Integer)this.getTestValue())), (String)"single false predicate evaluated to true");
    }

    @Test
    public void testOneTruePredicate() {
        Predicate predicate = this.createMockPredicate(true);
        Assertions.assertTrue((boolean)AllPredicate.allPredicate((Predicate[])new Predicate[]{predicate}).test((Object)((Integer)this.getTestValue())), (String)"single true predicate evaluated to false");
    }

    @Test
    public void testTrueAndFalseCombined() {
        Assertions.assertFalse((boolean)this.getPredicateInstance(false, null).evaluate((Object)((Integer)this.getTestValue())), (String)"false predicate evaluated to true");
        Assertions.assertFalse((boolean)this.getPredicateInstance(false, null, null).evaluate((Object)((Integer)this.getTestValue())), (String)"false predicate evaluated to true");
        Assertions.assertFalse((boolean)this.getPredicateInstance(true, false, null).evaluate((Object)((Integer)this.getTestValue())), (String)"false predicate evaluated to true");
        Assertions.assertFalse((boolean)this.getPredicateInstance(true, true, false).evaluate((Object)((Integer)this.getTestValue())), (String)"false predicate evaluated to true");
        Assertions.assertFalse((boolean)this.getPredicateInstance(true, true, false, null).evaluate((Object)((Integer)this.getTestValue())), (String)"false predicate evaluated to true");
    }
}

