#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <vga.h>
#include <vgagl.h>
#include "hangul.h"

void hinitgraph(int mode, char *han, char *eng, int font_mothod) {
	static char hanfontname[256], engfontname[256];
  if(strcmp("xterm",(char *)getenv("TERM"))== 0) {
    fprintf(stderr, "This program run in console mode!\n");
    exit(1);
  }
  vga_setmode(mode);
  gl_setcontextvga(mode);

  if (font_mothod == DEFAULT_FONT) {
		sprintf( engfontname, "/usr/local/lib/fonts/%s", eng);
		sprintf( hanfontname, "/usr/local/lib/fonts/%s", han);
	} else {
		strcpy(engfontname, eng);
		strcpy(hanfontname, han);
	}
  hloadfont(hanfontname, engfontname);
}

void hclosegraph() { 
  vga_setmode(TEXT);
}
