#include "hangul.h"

#define KS5061_VERIFY_COUNT	100  

#define is_ks5061_code(x)  \
        ((x > 0xa1a1 && x < 0xa1ff) || \
         (x > 0xa2a0 && x < 0xa2e6) || \
         (x > 0xa3a0 && x < 0xa3ff) || \
         (x > 0xa4a0 && x < 0xa4ff) || \
         (x > 0xa5a0 && x < 0xa5f9) || \
         (x > 0xa6a0 && x < 0xa6e5) || \
         (x > 0xa7a0 && x < 0xa7f0) || \
         (x > 0xa8a0 && x < 0xa8ff) || \
         (x > 0xa9a0 && x < 0xa9ff) || \
         (x > 0xaaa0 && x < 0xaaf4) || \
         (x > 0xaba0 && x < 0xabf7) || \
         (x > 0xaca0 && x < 0xacc2) || \
         (x > 0xacd0 && x < 0xacf2) || \
                                       \
         (x > 0xb0a0 && x < 0xb0ff) || \
         (x > 0xb1a0 && x < 0xb1ff) || \
         (x > 0xb2a0 && x < 0xb2ff) || \
         (x > 0xb3a0 && x < 0xb3ff) || \
         (x > 0xb4a0 && x < 0xb4ff) || \
         (x > 0xb5a0 && x < 0xb5ff) || \
         (x > 0xb6a0 && x < 0xb6ff) || \
         (x > 0xb7a0 && x < 0xb7ff) || \
         (x > 0xb8a0 && x < 0xb8ff) || \
         (x > 0xb9a0 && x < 0xb9ff) || \
         (x > 0xbaa0 && x < 0xbaff) || \
         (x > 0xbba0 && x < 0xbbff) || \
         (x > 0xbca0 && x < 0xbcff) || \
         (x > 0xbda0 && x < 0xbdff) || \
         (x > 0xbea0 && x < 0xbeff) || \
         (x > 0xbfa0 && x < 0xbfff) || \
                                       \
         (x > 0xc0a0 && x < 0xc0ff) || \
         (x > 0xc1a0 && x < 0xc1ff) || \
         (x > 0xc2a0 && x < 0xc2ff) || \
         (x > 0xc3a0 && x < 0xc3ff) || \
         (x > 0xc4a0 && x < 0xc4ff) || \
         (x > 0xc5a0 && x < 0xc5ff) || \
         (x > 0xc6a0 && x < 0xc6ff) || \
         (x > 0xc7a0 && x < 0xc7ff) || \
         (x > 0xc8a0 && x < 0xc8ff) || \
                                       \
         (x > 0xcaa0 && x < 0xcaff) || \
         (x > 0xcba0 && x < 0xcbff) || \
         (x > 0xcca0 && x < 0xccff) || \
         (x > 0xcda0 && x < 0xcdff) || \
         (x > 0xcea0 && x < 0xceff) || \
         (x > 0xcfa0 && x < 0xcfff) || \
                                       \
         (x > 0xd0a0 && x < 0xd0ff) || \
         (x > 0xd1a0 && x < 0xd1ff) || \
         (x > 0xd2a0 && x < 0xd2ff) || \
         (x > 0xd3a0 && x < 0xd3ff) || \
         (x > 0xd4a0 && x < 0xd4ff) || \
         (x > 0xd5a0 && x < 0xd5ff) || \
         (x > 0xd6a0 && x < 0xd6ff) || \
         (x > 0xd7a0 && x < 0xd7ff) || \
         (x > 0xd8a0 && x < 0xd8ff) || \
         (x > 0xd9a0 && x < 0xd9ff) || \
         (x > 0xdaa0 && x < 0xdaff) || \
         (x > 0xdba0 && x < 0xdbff) || \
         (x > 0xdca0 && x < 0xdcff) || \
         (x > 0xdda0 && x < 0xddff) || \
         (x > 0xdea0 && x < 0xdeff) || \
         (x > 0xdfa0 && x < 0xdfff) || \
                                       \
         (x > 0xe0a0 && x < 0xe0ff) || \
         (x > 0xe1a0 && x < 0xe1ff) || \
         (x > 0xe2a0 && x < 0xe2ff) || \
         (x > 0xe3a0 && x < 0xe3ff) || \
         (x > 0xe4a0 && x < 0xe4ff) || \
         (x > 0xe5a0 && x < 0xe5ff) || \
         (x > 0xe6a0 && x < 0xe6ff) || \
         (x > 0xe7a0 && x < 0xe7ff) || \
         (x > 0xe8a0 && x < 0xe8ff) || \
         (x > 0xe9a0 && x < 0xe9ff) || \
         (x > 0xeaa0 && x < 0xeaff) || \
         (x > 0xeba0 && x < 0xebff) || \
         (x > 0xeca0 && x < 0xecff) || \
         (x > 0xeda0 && x < 0xedff) || \
         (x > 0xeea0 && x < 0xeeff) || \
         (x > 0xefa0 && x < 0xefff) || \
                                       \
         (x > 0xf0a0 && x < 0xf0ff) || \
         (x > 0xf1a0 && x < 0xf1ff) || \
         (x > 0xf2a0 && x < 0xf2ff) || \
         (x > 0xf3a0 && x < 0xf3ff) || \
         (x > 0xf4a0 && x < 0xf4ff) || \
         (x > 0xf5a0 && x < 0xf5ff) || \
         (x > 0xf6a0 && x < 0xf6ff) || \
         (x > 0xf7a0 && x < 0xf7ff) || \
         (x > 0xf8a0 && x < 0xf8ff) || \
         (x > 0xf9a0 && x < 0xf9ff) || \
         (x > 0xfaa0 && x < 0xfaff) || \
         (x > 0xfba0 && x < 0xfbff) || \
         (x > 0xfca0 && x < 0xfcff) || \
         (x > 0xfda0 && x < 0xfdff)) 


int hanautodistfile(FILE *fp) {
   int	code= CODE_ENGLISH;         
   int	key;                         
   int	hangul_code;                
   int	first;                   
   int	second;                     
   int	ks_count = 0;               
   long	old_position;               
   
   old_position = ftell(fp);
   rewind(fp);
   
   while((key = fgetc(fp)) != EOF) {
      if(key < 128)                 
         continue;
      first = key;                  
      second= fgetc(fp);
      hangul_code = (first << 8) + second; 
      if (is_ks5061_code(hangul_code)) { 
         if(!ks_count)       
            code = CODE_KS5061;  
         if(ks_count++ >= KS5061_VERIFY_COUNT) 
            break;               
      } else {
         code = CODE_JOHAP;      
         break;
      }
   }
   fseek(fp, old_position, 0);
   return code;                  
}

int hanautodiststr(byte *str) {
   int	code= CODE_ENGLISH;         
   int	key;                         
   int	hangul_code;                
   int	first;                   
   int	second;                     
   int	ks_count = 0;               
   
   while((key = *str++) != '\0') {
      if(key < 128)                 
         continue;
      first = key;                  
      second= *str++;
      hangul_code = (first << 8) + second; 
      if (is_ks5061_code(hangul_code)) { 
         if(!ks_count)       
            code = CODE_KS5061;  
         if(ks_count++ >= KS5061_VERIFY_COUNT) 
            break;               
      } else {
         code = CODE_JOHAP;      
         break;
      }
   }
   return code;                  
}
